/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class StringUtils {
    private static MessageDigest s_md5Processor;

    public static boolean isNullOrEmpty(String _str) {
        if (_str == null) {
            return true;
        }
        return _str.isEmpty();
    }

    public static String join(String _separator, String[] _items) {
        return StringUtils.join(_separator, Arrays.asList(_items));
    }

    public static String join(String _separator, Iterable<String> _items) {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (String item : _items) {
            if (first) {
                first = false;
            } else {
                ret.append(_separator);
            }
            ret.append(item);
        }
        return ret.toString();
    }

    public static String[] split(String _input, String _separator) {
        int start;
        if (_separator.isEmpty()) {
            throw new IllegalArgumentException("_separator must not be the empty string.");
        }
        ArrayList<String> ret = new ArrayList<String>();
        int lastEnd = 0;
        while ((start = _input.indexOf(_separator, lastEnd)) != -1) {
            ret.add(_input.substring(lastEnd, start));
            lastEnd = start + _separator.length();
        }
        ret.add(_input.substring(lastEnd));
        return ret.toArray(new String[0]);
    }

    public static Map<String, String> stringMap(String ... _keysAndValues) {
        assert (_keysAndValues.length % 2 == 0);
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int i = 0; i < _keysAndValues.length; i += 2) {
            ret.put(_keysAndValues[i], _keysAndValues[i + 1]);
        }
        return ret;
    }

    public static String strip(String _string) {
        if (_string == null) {
            return null;
        }
        return _string.replaceAll("\\s+", "");
    }

    public static byte[] md5(String _value) {
        if (s_md5Processor == null) {
            try {
                s_md5Processor = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return s_md5Processor.digest(_value.getBytes());
    }
}

