/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TTLCache<K, V> {
    private final ConcurrentHashMap<K, TTLEntry<V>> mKey2Entry = new ConcurrentHashMap();
    private final long mExpiresAfterNanos;
    private final AtomicLong mLastCheckTime = new AtomicLong(0L);
    private final IRemovalHandler<K, V> mHandler;

    public TTLCache(long expiresAfter, TimeUnit unit) {
        this(expiresAfter, unit, null);
    }

    public TTLCache(long expiresAfter, TimeUnit unit, IRemovalHandler<K, V> handler) {
        this.mExpiresAfterNanos = unit.toNanos(expiresAfter);
        this.mHandler = handler;
    }

    public int size() {
        return this.mKey2Entry.size();
    }

    public boolean containsKey(K key) {
        this.checkExpiredEntries();
        TTLEntry<V> entry = this.mKey2Entry.get(key);
        if (null == entry) {
            return false;
        }
        return !entry.hasExpired();
    }

    public V get(K key) {
        this.checkExpiredEntries();
        TTLEntry<V> entry = this.mKey2Entry.get(key);
        if (null == entry) {
            return null;
        }
        entry.setExpiresOn(System.nanoTime() + this.mExpiresAfterNanos);
        return (V)((TTLEntry)entry).mValue;
    }

    public V put(K key, V value) {
        this.checkExpiredEntries();
        TTLEntry<V> newEntry = new TTLEntry<V>(value, System.nanoTime() + this.mExpiresAfterNanos);
        TTLEntry<V> oldEntry = this.mKey2Entry.put(key, newEntry);
        if (null != oldEntry) {
            if (null != this.mHandler) {
                this.mHandler.onReplaced(key, ((TTLEntry)oldEntry).mValue);
            }
            return (V)((TTLEntry)oldEntry).mValue;
        }
        return null;
    }

    public V putIfAbsent(K key, V value) {
        TTLEntry<V> oldEntry;
        this.checkExpiredEntries();
        TTLEntry<V> newEntry = new TTLEntry<V>(value, System.nanoTime() + this.mExpiresAfterNanos);
        while (null != (oldEntry = this.mKey2Entry.putIfAbsent(key, newEntry))) {
            if (oldEntry.hasExpired() && this.mKey2Entry.remove(key, oldEntry)) {
                if (null == this.mHandler) continue;
                this.mHandler.onExpired(key, ((TTLEntry)oldEntry).mValue);
                continue;
            }
            return (V)((TTLEntry)oldEntry).mValue;
        }
        return null;
    }

    public void invalidate(K key) {
        this.checkExpiredEntries();
        TTLEntry<V> oldEntry = this.mKey2Entry.remove(key);
        if (null != oldEntry && null != this.mHandler) {
            this.mHandler.onInvalidated(key, ((TTLEntry)oldEntry).mValue);
        }
    }

    public void clear() {
        this.mKey2Entry.clear();
    }

    public String toString() {
        return this.mKey2Entry.toString();
    }

    private void checkExpiredEntries() {
        long tmp;
        do {
            tmp = this.mLastCheckTime.get();
            if (System.nanoTime() - tmp >= this.mExpiresAfterNanos) continue;
            return;
        } while (!this.mLastCheckTime.compareAndSet(tmp, System.nanoTime()));
        for (Map.Entry<K, TTLEntry<V>> e : this.mKey2Entry.entrySet()) {
            K key = e.getKey();
            TTLEntry<V> entry = e.getValue();
            if (!entry.hasExpired() || !this.mKey2Entry.remove(key, entry) || null == this.mHandler) continue;
            this.mHandler.onExpired(key, ((TTLEntry)entry).mValue);
        }
    }

    private static final class TTLEntry<V> {
        private final V mValue;
        private volatile long mExpiresOn;

        TTLEntry(V value, long expiresOn) {
            this.mValue = value;
            this.mExpiresOn = expiresOn;
        }

        boolean hasExpired() {
            return System.nanoTime() > this.mExpiresOn;
        }

        void setExpiresOn(long expiresOn) {
            this.mExpiresOn = expiresOn;
        }

        public String toString() {
            return String.valueOf(this.mValue);
        }
    }

    public static interface IRemovalHandler<K, V> {
        public void onExpired(K var1, V var2);

        public void onReplaced(K var1, V var2);

        public void onInvalidated(K var1, V var2);
    }
}

