/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadFactories {
    private ThreadFactories() {
    }

    public static ThreadFactory create(String namePrefix, boolean isDaemon, ThreadGroup group, Thread.UncaughtExceptionHandler defaultHandler) {
        return new ThreadFactoryImpl(namePrefix, isDaemon, group, defaultHandler);
    }

    public static ThreadFactory create(String namePrefix, boolean isDaemon, ThreadGroup group) {
        return new ThreadFactoryImpl(namePrefix, isDaemon, group, null);
    }

    public static ThreadFactory create(String namePrefix, boolean isDaemon) {
        return new ThreadFactoryImpl(namePrefix, isDaemon, null, null);
    }

    public static ThreadFactory create(String namePrefix) {
        return new ThreadFactoryImpl(namePrefix, false, null, null);
    }

    private static final class ThreadFactoryImpl
    implements ThreadFactory {
        private final String mNamePrefix;
        private final boolean mDaemon;
        private final ThreadGroup mGroup;
        private final Thread.UncaughtExceptionHandler mDefaultHandler;
        private final AtomicInteger mCounter = new AtomicInteger(0);

        ThreadFactoryImpl(String namePrefix, boolean isDaemon, ThreadGroup group, Thread.UncaughtExceptionHandler defaultHandler) {
            this.mNamePrefix = namePrefix;
            this.mDaemon = isDaemon;
            this.mGroup = group;
            this.mDefaultHandler = defaultHandler;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.mGroup, r, this.newName());
            t.setDaemon(this.mDaemon);
            t.setUncaughtExceptionHandler(this.mDefaultHandler);
            return t;
        }

        private String newName() {
            return this.mNamePrefix + Integer.toString(this.mCounter.incrementAndGet());
        }
    }
}

