/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util;

import java.util.Random;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.math.RandomUtils;

public class WeightedRandomSelector {
    private final double[] mWeights;

    public WeightedRandomSelector(double[] weights) {
        int i;
        if (null == weights) {
            throw new NullArgumentException("weights");
        }
        this.mWeights = new double[weights.length];
        double total = 0.0;
        for (i = 0; i < weights.length; ++i) {
            total += weights[i];
        }
        for (i = 0; i < weights.length; ++i) {
            this.mWeights[i] = weights[i] / total;
        }
    }

    public int select(Random random) {
        double r = random.nextDouble();
        for (int i = 0; i < this.mWeights.length; ++i) {
            if (r < this.mWeights[i]) {
                return i;
            }
            r -= this.mWeights[i];
        }
        return 0;
    }

    public int select() {
        return this.select(RandomUtils.JVM_RANDOM);
    }
}

