/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util.ops;

import com.ibm.neo.util.IObserver;
import com.ibm.neo.util.ObservableHelper;
import com.ibm.neo.util.ops.IOperation;
import com.ibm.neo.util.ops.ProgressHelper;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperation
extends ProgressHelper
implements IOperation {
    private final Logger mLogger;
    private final ObservableHelper<IOperation> mOpObserverHelper = new ObservableHelper();
    private final CountDownLatch mLatch = new CountDownLatch(1);
    private volatile boolean mStarted = false;
    private volatile boolean mFinished = false;
    private volatile boolean mCanceled = false;
    private volatile Throwable mError = null;

    protected AbstractOperation() {
        this.mLogger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public double getPercentCompleted() {
        if (this.mFinished) {
            return 100.0;
        }
        return super.getPercentCompleted();
    }

    @Override
    public final boolean hasStarted() {
        return this.mStarted;
    }

    @Override
    public final boolean hasFinished() {
        return this.mFinished;
    }

    @Override
    public final boolean hasFailed() {
        return this.mFinished && null != this.mError;
    }

    @Override
    public final boolean isRunning() {
        return this.mStarted && !this.mFinished;
    }

    @Override
    public final boolean isCanceled() {
        return this.mCanceled;
    }

    @Override
    public final void cancel() {
        if (this.mFinished || this.mCanceled) {
            return;
        }
        this.mLogger.info("Operation canceled");
        this.mCanceled = true;
        if (this.mStarted) {
            this.cancelImpl();
        }
    }

    protected abstract void cancelImpl();

    protected final void markAsStarted() {
        if (this.mCanceled) {
            throw new CancellationException();
        }
        this.mLogger.debug("Operation started");
        this.mStarted = true;
        this.mOpObserverHelper.updateObservers(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void markAsFinished() {
        if (this.mFinished) {
            return;
        }
        this.mLogger.debug("Operation finished");
        this.mFinished = true;
        try {
            this.setCompletedWork(this.getTotalWork());
            this.mOpObserverHelper.updateObservers(this);
        }
        finally {
            this.mLatch.countDown();
        }
    }

    protected final void markAsFailed(Throwable error) {
        if (this.mFinished) {
            return;
        }
        this.mLogger.error("Operation failed", error);
        this.mError = error;
        this.markAsFinished();
    }

    @Override
    public final Throwable getError() {
        return this.mError;
    }

    @Override
    public final void waitFor() throws InterruptedException {
        if (!this.mFinished) {
            this.mLatch.await();
        }
    }

    @Override
    public final boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.mFinished) {
            return this.mLatch.await(timeout, unit);
        }
        return true;
    }

    @Override
    public void join() throws ExecutionException, CancellationException {
        while (!this.hasFinished()) {
            try {
                this.waitFor();
            }
            catch (InterruptedException ex) {}
        }
        if (this.hasFailed()) {
            throw new ExecutionException(this.getError());
        }
    }

    @Override
    public void join(long timeout, TimeUnit unit) throws ExecutionException, CancellationException, TimeoutException {
        while (!this.hasFinished()) {
            try {
                if (this.waitFor(timeout, unit)) continue;
                throw new TimeoutException();
            }
            catch (InterruptedException e) {
            }
        }
        if (this.hasFailed()) {
            throw new ExecutionException(this.getError());
        }
    }

    @Override
    public final void addOperationObserver(IObserver<IOperation> observer) {
        this.mOpObserverHelper.addObserver(observer);
    }

    @Override
    public final void removeOperationObserver(IObserver<IOperation> observer) {
        this.mOpObserverHelper.removeObserver(observer);
    }
}

