/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util.ops;

import com.ibm.neo.util.IObserver;
import com.ibm.neo.util.ops.IOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class OperationExecutor {
    private final ExecutorService mExecutorService;
    private final ConcurrentHashMap<IOperation, Future<?>> mOp2Future = new ConcurrentHashMap();
    private final OpObserver mObserver = new OpObserver();

    public OperationExecutor(ExecutorService executorService) {
        this.mExecutorService = executorService;
    }

    public void shutdown() {
        this.mExecutorService.shutdown();
    }

    public List<IOperation> shutdownNow(boolean forceCancel) {
        List<Runnable> runnables = this.mExecutorService.shutdownNow();
        ArrayList<IOperation> ops = new ArrayList<IOperation>(runnables.size());
        for (Runnable r : runnables) {
            IOperation op = (IOperation)((Object)r);
            ops.add(op);
        }
        for (IOperation op : this.mOp2Future.keySet()) {
            if (!forceCancel) continue;
            op.cancel();
        }
        this.mOp2Future.clear();
        return ops;
    }

    public boolean isShutdown() {
        return this.mExecutorService.isShutdown();
    }

    public boolean isTerminated() {
        return this.mExecutorService.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.mExecutorService.awaitTermination(timeout, unit);
    }

    public void submit(IOperation operation) {
        Future<Object> future;
        if (this.mExecutorService.isShutdown()) {
            throw new RejectedExecutionException("Executor was shutdown");
        }
        if (operation instanceof Runnable) {
            operation.addOperationObserver(this.mObserver);
            try {
                future = this.mExecutorService.submit((Runnable)((Object)operation));
            }
            catch (RejectedExecutionException ex) {
                operation.removeOperationObserver(this.mObserver);
                throw ex;
            }
        } else if (operation instanceof Callable) {
            operation.addOperationObserver(this.mObserver);
            try {
                future = this.mExecutorService.submit((Callable)((Object)operation));
            }
            catch (RejectedExecutionException ex) {
                operation.removeOperationObserver(this.mObserver);
                throw ex;
            }
        } else {
            throw new IllegalArgumentException("Operation must be Runnable or Callable.");
        }
        this.mOp2Future.put(operation, future);
    }

    private final class OpObserver
    implements IObserver<IOperation> {
        private OpObserver() {
        }

        @Override
        public void updated(IOperation subject) {
            if (subject.hasFinished()) {
                Future future = (Future)OperationExecutor.this.mOp2Future.remove(subject);
                if (null != future) {
                    future.cancel(false);
                }
                subject.removeOperationObserver(this);
            }
        }
    }
}

