/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util.ops;

import com.ibm.neo.util.IObserver;
import com.ibm.neo.util.ops.IProgress;
import java.util.ArrayList;
import java.util.List;

public abstract class ProgressAggregator {
    protected final List<IProgress> mSources = new ArrayList<IProgress>();
    protected final List<Double> mWeights = new ArrayList<Double>();
    protected final IObserver<ProgressAggregator> mObserver;
    protected double mTotalWeight = 0.0;

    public ProgressAggregator(IObserver<ProgressAggregator> observer) {
        this.mObserver = observer;
    }

    public synchronized void addSource(IProgress source, double weight) {
        this.mSources.add(source);
        this.mWeights.add(weight);
        this.updateTotalWeight(weight);
        source.addProgressObserver(new IObserver<IProgress>(){

            @Override
            public void updated(IProgress subject) {
                ProgressAggregator.this.mObserver.updated(ProgressAggregator.this);
            }
        });
        this.mObserver.updated(this);
    }

    protected abstract double updateTotalWeight(double var1);

    public synchronized double getPercentCompleted() {
        double weightedSum = 0.0;
        if (this.mTotalWeight == 0.0) {
            return weightedSum;
        }
        for (int i = 0; i < this.mSources.size(); ++i) {
            weightedSum += this.mWeights.get(i) * this.mSources.get(i).getPercentCompleted();
        }
        return weightedSum / this.mTotalWeight;
    }

    public synchronized int countFinishedSources() {
        int count = 0;
        for (IProgress source : this.mSources) {
            if (!(source.getPercentCompleted() >= 100.0)) continue;
            ++count;
        }
        return count;
    }

    public synchronized int countSources() {
        return this.mSources.size();
    }
}

