/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.util.ops;

import com.ibm.neo.util.IObserver;
import com.ibm.neo.util.ObservableHelper;
import com.ibm.neo.util.ops.IProgress;

public class ProgressHelper
implements IProgress {
    private final ObservableHelper<IProgress> mProgressObserverHelper = new ObservableHelper();
    private volatile long mTotalWork = 0L;
    private volatile long mCompletedWork = 0L;

    public ProgressHelper() {
    }

    public ProgressHelper(long totalWork) {
        this.mTotalWork = totalWork;
    }

    @Override
    public long getTotalWork() {
        return this.mTotalWork;
    }

    @Override
    public long getCompletedWork() {
        return this.mCompletedWork;
    }

    @Override
    public double getPercentCompleted() {
        double total = this.mTotalWork;
        double completed = this.mCompletedWork;
        if (total <= 0.0) {
            return 0.0;
        }
        if (completed >= total) {
            return 100.0;
        }
        return 100.0 * completed / total;
    }

    public void setTotalWork(long totalWork) {
        this.mTotalWork = totalWork;
        this.mProgressObserverHelper.updateObservers(this);
    }

    public void setCompletedWork(long completedWork) {
        this.mCompletedWork = completedWork;
        this.mProgressObserverHelper.updateObservers(this);
    }

    @Override
    public void addProgressObserver(IObserver<IProgress> observer) {
        this.mProgressObserverHelper.addObserver(observer);
    }

    @Override
    public void removeProgressObserver(IObserver<IProgress> observer) {
        this.mProgressObserverHelper.removeObserver(observer);
    }
}

