/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.neo.blobstore.AbstractBlobContainer;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlob;
import com.ibm.neo.blobstore.IBlobContainer;
import com.ibm.neo.blobstore.IBlobStore;
import com.ibm.neo.crypto.service.CryptoService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public abstract class AbstractBlob
implements IBlob {
    private static final ThreadLocal<DateFormat> ISO_DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat initialValue() {
            SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
            isoFormat.setTimeZone(TimeZone.getTimeZone((String)"UTC"));
            return isoFormat;
        }
    };
    private final AbstractBlobContainer mContainer;
    private final String mKey;
    private final String mFilename;
    private final String mContentType;
    private final long mContentLength;
    private final Date mCreationTime;
    private final boolean mCompressed;
    private final boolean mEncrypted;

    protected AbstractBlob(AbstractBlobContainer container, String key, String filename, String contentType, long contentLength, Date creationTime, boolean isCompressed, boolean isEncrypted) {
        if (null == container) {
            throw new NullArgumentException("container");
        }
        if (null == key) {
            throw new NullArgumentException("key");
        }
        if (null == filename) {
            throw new NullArgumentException("filename");
        }
        if (null == creationTime) {
            throw new NullArgumentException("creationTime");
        }
        this.mContainer = container;
        this.mKey = key;
        this.mFilename = filename;
        this.mContentType = contentType;
        this.mContentLength = contentLength;
        this.mCreationTime = creationTime;
        this.mCompressed = isCompressed;
        this.mEncrypted = isEncrypted;
    }

    @Override
    public IBlobStore getStore() {
        return this.mContainer.getStore();
    }

    protected final Properties getConfiguration() {
        return this.mContainer.getConfiguration();
    }

    protected final CryptoService getCrypto() {
        return this.mContainer.getCrypto();
    }

    @Override
    public IBlobContainer getContainer() {
        return this.mContainer;
    }

    @Override
    public String getKey() {
        return this.mKey;
    }

    @Override
    public String getFilename() {
        return this.mFilename;
    }

    @Override
    public String getContentType() {
        return this.mContentType;
    }

    @Override
    public long getContentLength() {
        return this.mContentLength;
    }

    @Override
    public Date getCreationTime() {
        return this.mCreationTime;
    }

    @Override
    public boolean isCompressed() {
        return this.mCompressed;
    }

    @Override
    public boolean isEncrypted() {
        return this.mEncrypted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(File f) throws BlobStoreException, IOException {
        FileOutputStream out = new FileOutputStream(f);
        try {
            InputStream in = this.open();
            try {
                IOUtils.copyLarge((InputStream)in, (OutputStream)out);
            }
            finally {
                in.close();
            }
        }
        finally {
            out.close();
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("container", (Object)this.mContainer.getName()).append("key", (Object)this.mKey).append("filename", (Object)this.mFilename).append("contentType", (Object)this.mContentType).append("contentLength", this.mContentLength).append("compressed", this.mCompressed).append("encrypted", this.mEncrypted).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IBlob)) {
            return false;
        }
        IBlob other = (IBlob)o;
        if (!this.mContainer.equals(other.getContainer())) {
            return false;
        }
        return this.mKey.equals(other.getKey());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.mContainer).append((Object)this.mKey).toHashCode();
    }

    protected static Date parseISO8601Timestamp(String str) {
        try {
            return ISO_DATE_FORMAT.get().parse(str);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid ISO8601 timestamp: " + str);
        }
    }

    protected static String formatISO8601Timestamp(Date date) {
        return ISO_DATE_FORMAT.get().format(date);
    }
}

