/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore;

import com.ibm.neo.blobstore.AbstractBlobStore;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlob;
import com.ibm.neo.blobstore.IBlobContainer;
import com.ibm.neo.blobstore.IBlobStore;
import com.ibm.neo.crypto.service.CryptoService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public abstract class AbstractBlobContainer
implements IBlobContainer {
    private final AbstractBlobStore mStore;
    private final String mName;

    protected AbstractBlobContainer(AbstractBlobStore store, String name) {
        if (null == store) {
            throw new NullArgumentException("store");
        }
        if (null == name) {
            throw new NullArgumentException("name");
        }
        this.mStore = store;
        this.mName = name;
    }

    protected final Properties getConfiguration() {
        return this.mStore.getConfiguration();
    }

    protected final CryptoService getCrypto() {
        return this.mStore.getCrypto();
    }

    protected final boolean shouldEncrypt() throws BlobStoreException.CryptoNotSupported {
        return this.mStore.shouldEncrypt();
    }

    @Override
    public IBlobStore getStore() {
        return this.mStore;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public final IBlob create(String filename, String contentType, InputStream contentStream) throws BlobStoreException, IOException {
        return this.create(filename, contentType, contentStream, false);
    }

    @Override
    public final IBlob create(String key, String filename, String contentType, InputStream contentStream) throws BlobStoreException, IOException {
        return this.create(key, filename, contentType, contentStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public final IBlob create(String filename, String contentType, File contentFile, boolean compress) throws BlobStoreException, IOException {
        FileInputStream in = new FileInputStream(contentFile);
        try {
            IBlob iBlob = this.create(filename, contentType, in, compress);
            return iBlob;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public final IBlob create(String key, String filename, String contentType, File contentFile, boolean compress) throws BlobStoreException, IOException {
        FileInputStream in = new FileInputStream(contentFile);
        try {
            IBlob iBlob = this.create(key, filename, contentType, in, compress);
            return iBlob;
        }
        finally {
            in.close();
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("store", (Object)this.mStore).append("name", (Object)this.mName).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IBlobContainer)) {
            return false;
        }
        IBlobContainer other = (IBlobContainer)o;
        if (!this.mStore.equals(other.getStore())) {
            return false;
        }
        return this.mName.equals(other.getName());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.mStore).append((Object)this.mName).toHashCode();
    }
}

