/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore;

import com.ibm.neo.blobstore.BlobEncryptionFeature;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlobStore;
import com.ibm.neo.crypto.service.CryptoService;
import java.util.Properties;
import org.apache.commons.lang.NullArgumentException;

public abstract class AbstractBlobStore
implements IBlobStore {
    private final Properties config;
    private final CryptoService crypto;

    protected AbstractBlobStore(Properties config, CryptoService crypto) {
        if (null == config) {
            throw new NullArgumentException("config");
        }
        if (null == crypto) {
            throw new NullArgumentException("crypto");
        }
        this.config = config;
        this.crypto = crypto;
    }

    protected final Properties getConfiguration() {
        return this.config;
    }

    protected final CryptoService getCrypto() {
        return this.crypto;
    }

    protected final boolean shouldEncrypt() throws BlobStoreException.CryptoNotSupported {
        BlobEncryptionFeature.EncryptMode mode = BlobEncryptionFeature.getMode();
        switch (mode) {
            case MANDATORY: {
                if (!this.isEncryptionSupported()) {
                    throw new BlobStoreException.CryptoNotSupported();
                }
                return true;
            }
            case OPTIONAL: {
                return this.isEncryptionSupported();
            }
        }
        return false;
    }

    private boolean isEncryptionSupported() {
        return this.crypto.isEnabled() && "true".equalsIgnoreCase(this.config.getProperty("neo.blobstore.encryption.enabled"));
    }
}

