/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore;

import com.ibm.neo.security.ACSHelper;
import com.ibm.wa.webclient.util.WatsonHeaders;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.ShiroException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;

public class BlobEncryptionFeature {
    public static final String HEADER_BA_CRYPTO = "ba-crypto";
    public static final String FLAG_BLOB_ENCRYPTION = "blob-encryption";

    private BlobEncryptionFeature() {
    }

    public static EncryptMode getMode() {
        Map headers;
        try {
            Subject subject = ThreadContext.getSubject();
            headers = null != subject ? ACSHelper.getHttpHeaders((Subject)subject) : null;
        }
        catch (ShiroException ex) {
            return EncryptMode.DISABLED;
        }
        if (null == headers || headers.isEmpty()) {
            return EncryptMode.DISABLED;
        }
        String cryptoHeader = WatsonHeaders.getFirstValue((Map)headers, (String)HEADER_BA_CRYPTO, (boolean)true);
        if (StringUtils.isEmpty((String)cryptoHeader)) {
            return EncryptMode.DISABLED;
        }
        Properties cryptoFlags = WatsonHeaders.decodeKeyValuePairs((String)cryptoHeader);
        String encryptMode = cryptoFlags.getProperty(FLAG_BLOB_ENCRYPTION);
        if (StringUtils.isEmpty((String)encryptMode)) {
            return EncryptMode.DISABLED;
        }
        try {
            return EncryptMode.valueOf(encryptMode.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return EncryptMode.DISABLED;
        }
    }

    public static enum EncryptMode {
        DISABLED,
        OPTIONAL,
        MANDATORY;

    }
}

