/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore;

public class BlobStoreException
extends Exception {
    private static final long serialVersionUID = 1L;

    public BlobStoreException(String message) {
        super(message);
    }

    public BlobStoreException(Throwable cause) {
        super(cause);
    }

    public BlobStoreException(String message, Throwable cause) {
        super(message, cause);
    }

    public static final class ConfigError
    extends BlobStoreException {
        private static final long serialVersionUID = 1L;

        public ConfigError() {
            super("Configuration error");
        }

        public ConfigError(String message) {
            super(message);
        }

        public ConfigError(Throwable cause) {
            super(cause);
        }

        public ConfigError(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class CryptoNotSupported
    extends CryptoError {
        private static final long serialVersionUID = 1L;

        public CryptoNotSupported() {
            super("Encryption is mandatory for the current user, but encryption is not supported by the current configuration.");
        }
    }

    public static class CryptoError
    extends BlobStoreException {
        private static final long serialVersionUID = 1L;

        public CryptoError() {
            super("Cryptography error");
        }

        public CryptoError(String message) {
            super(message);
        }

        public CryptoError(Throwable cause) {
            super(cause);
        }

        public CryptoError(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static final class ChecksumMismatch
    extends BlobStoreException {
        private static final long serialVersionUID = 1L;

        public ChecksumMismatch() {
            super("Checksum mismatch");
        }

        public ChecksumMismatch(Throwable cause) {
            super("Checksum mismatch", cause);
        }
    }

    public static final class BlobNotFound
    extends BlobStoreException {
        private static final long serialVersionUID = 1L;

        public BlobNotFound(String container, String key) {
            super("Blob not found: " + container + "/" + key);
        }
    }

    public static final class ContainerNotFound
    extends BlobStoreException {
        private static final long serialVersionUID = 1L;

        public ContainerNotFound(String container) {
            super("Container not found: " + container);
        }
    }
}

