/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore.file;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.blobstore.AbstractBlobContainer;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlob;
import com.ibm.neo.blobstore.file.FileBlob;
import com.ibm.neo.blobstore.file.FileBlobStore;
import com.ibm.neo.crypto.service.CryptoException;
import com.ibm.neo.io.GzipCompressingInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileBlobContainer
extends AbstractBlobContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBlobContainer.class);
    private final File mContainerDir;

    FileBlobContainer(FileBlobStore store, File containerDir) {
        super(store, FileBlobContainer.getContainerName(containerDir));
        this.mContainerDir = containerDir;
    }

    @Override
    public boolean supportsCustomBlobKeys() {
        return true;
    }

    @Override
    public boolean exists() throws BlobStoreException {
        return this.mContainerDir.exists();
    }

    @Override
    public Iterator<IBlob> iterator() {
        try {
            if (!this.exists()) {
                throw new BlobStoreException.ContainerNotFound(this.getName());
            }
            ArrayList<IBlob> blobs = new ArrayList<IBlob>();
            for (File blobFile : this.mContainerDir.listFiles(new BlobFilter())) {
                File metaFile = new File(FilenameUtils.getFullPathNoEndSeparator((String)blobFile.getPath()), blobFile.getName() + ".meta");
                IBlob blob = this.readBlob(blobFile, metaFile);
                if (null == blob) continue;
                blobs.add(blob);
            }
            return blobs.iterator();
        }
        catch (BlobStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public IBlob get(String key) throws BlobStoreException {
        if (!this.exists()) {
            throw new BlobStoreException.ContainerNotFound(this.getName());
        }
        File blobFile = new File(this.mContainerDir.getPath(), key);
        File metaFile = new File(this.mContainerDir.getPath(), key + ".meta");
        return this.readBlob(blobFile, metaFile);
    }

    @Override
    public List<IBlob> findFilename(String filename) throws BlobStoreException {
        if (!this.exists()) {
            throw new BlobStoreException.ContainerNotFound(this.getName());
        }
        ArrayList<IBlob> blobs = new ArrayList<IBlob>();
        for (IBlob b : this) {
            if (!b.getFilename().equals(filename)) continue;
            blobs.add(b);
        }
        return blobs;
    }

    @Override
    public IBlob create(String filename, String contentType, InputStream contentStream, boolean compress) throws BlobStoreException, IOException {
        if (!this.exists()) {
            throw new BlobStoreException.ContainerNotFound(this.getName());
        }
        String key = UUID.randomUUID().toString();
        File blobFile = new File(this.mContainerDir.getPath(), key);
        File metaFile = new File(this.mContainerDir.getPath(), key + ".meta");
        return this.writeBlob(blobFile, metaFile, filename, contentType, contentStream, compress);
    }

    @Override
    public IBlob create(String key, String filename, String contentType, InputStream contentStream, boolean compress) throws BlobStoreException, IOException {
        if (!this.exists()) {
            throw new BlobStoreException.ContainerNotFound(this.getName());
        }
        File blobFile = new File(this.mContainerDir.getPath(), key);
        File metaFile = new File(this.mContainerDir.getPath(), key + ".meta");
        return this.writeBlob(blobFile, metaFile, filename, contentType, contentStream, compress);
    }

    @Override
    public void delete(String key) throws BlobStoreException {
        if (!this.exists()) {
            throw new BlobStoreException.ContainerNotFound(this.getName());
        }
        File blobFile = new File(this.mContainerDir.getPath(), key);
        File metaFile = new File(this.mContainerDir.getPath(), key + ".meta");
        try {
            if (blobFile.exists()) {
                FileUtils.forceDelete((File)blobFile);
            }
            if (metaFile.exists()) {
                FileUtils.forceDelete((File)metaFile);
            }
        }
        catch (IOException ex) {
            throw new BlobStoreException("Failed to remove blob: " + this.getName() + "/" + key, ex);
        }
    }

    private IBlob readBlob(File blobFile, File metaFile) throws BlobStoreException {
        if (!blobFile.exists() || !metaFile.exists()) {
            return null;
        }
        try {
            JSONObject jsonMeta = JSONObject.parse((String)FileUtils.readFileToString((File)metaFile, (String)"UTF-8"));
            String filename = (String)jsonMeta.get((Object)"filename");
            String contentType = (String)jsonMeta.get((Object)"content-type");
            boolean isCompressed = Boolean.TRUE.equals(jsonMeta.get((Object)"compressed"));
            boolean isEncrypted = Boolean.TRUE.equals(jsonMeta.get((Object)"encrypted"));
            return new FileBlob(this, blobFile, metaFile, filename, contentType, isCompressed, isEncrypted);
        }
        catch (Exception ex) {
            throw new BlobStoreException("Failed to read blob metadata from: " + metaFile.getPath(), ex);
        }
    }

    private IBlob writeBlob(File blobFile, File metaFile, String filename, String contentType, InputStream contentStream, boolean compress) throws BlobStoreException, IOException {
        boolean encrypt = this.shouldEncrypt();
        if (compress) {
            contentStream = new GzipCompressingInputStream(contentStream);
        }
        if (encrypt) {
            try {
                contentStream = this.getCrypto().encrypt(contentStream);
            }
            catch (CryptoException ex) {
                LOGGER.error("Failed to create encryption stream", (Throwable)ex);
                throw new BlobStoreException.CryptoError("Failed to create encryption stream", ex);
            }
        }
        LOGGER.info("Creating blob [filename={}, blobFile={}, compress={}, encrypt={}]", new Object[]{filename, blobFile.getPath(), compress, encrypt});
        FileOutputStream out = new FileOutputStream(blobFile);
        try {
            IOUtils.copy((InputStream)contentStream, (OutputStream)out);
        }
        catch (IOException e) {
            FileUtils.deleteQuietly((File)blobFile);
            throw e;
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
            ((OutputStream)out).close();
        }
        JSONObject jsonMeta = new JSONObject();
        jsonMeta.put((Object)"filename", (Object)filename);
        jsonMeta.put((Object)"content-type", (Object)contentType);
        jsonMeta.put((Object)"compressed", (Object)compress);
        jsonMeta.put((Object)"encrypted", (Object)encrypt);
        FileOutputStream metaOut = new FileOutputStream(metaFile);
        try {
            IOUtils.write((String)jsonMeta.serialize(true), (OutputStream)metaOut, (String)"UTF-8");
        }
        catch (IOException e) {
            FileUtils.deleteQuietly((File)blobFile);
            FileUtils.deleteQuietly((File)metaFile);
            throw e;
        }
        finally {
            ((OutputStream)metaOut).close();
        }
        return new FileBlob(this, blobFile, metaFile, filename, contentType, compress, encrypt);
    }

    private static String getContainerName(File containerDir) {
        int periodPos = containerDir.getName().indexOf(46);
        if (periodPos == -1) {
            throw new IllegalArgumentException("Invalid container directory: " + containerDir.getPath());
        }
        return containerDir.getName().substring(periodPos + 1);
    }

    @Override
    public IBlob create(String filename, String contentType, InputStream contentStream, boolean compress, int secondsToLive) throws BlobStoreException, IOException {
        return this.create(null, filename, contentType, contentStream, compress, secondsToLive);
    }

    @Override
    public IBlob create(String key, String filename, String contentType, InputStream contentStream, boolean compress, int secondsToLive) throws BlobStoreException, IOException {
        throw new UnsupportedOperationException("Implementation does not support secondsToLive.");
    }

    private static final class BlobFilter
    implements FileFilter {
        private BlobFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isFile() && !f.isHidden() && !FilenameUtils.getExtension((String)f.getName()).equals("meta");
        }
    }
}

