/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore.file;

import com.ibm.neo.blobstore.AbstractBlobStore;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlobContainer;
import com.ibm.neo.blobstore.file.FileBlobContainer;
import com.ibm.neo.crypto.service.CryptoService;
import com.ibm.neo.security.SubjectHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

class FileBlobStore
extends AbstractBlobStore {
    private final File mRootDir;

    FileBlobStore(Properties config, CryptoService crypto) throws BlobStoreException {
        super(config, crypto);
        String rootDirPath = config.getProperty("com.ibm.neo.blobstore.file.root-dir");
        if (null == rootDirPath) {
            throw new BlobStoreException("Missing required property: com.ibm.neo.blobstore.file.root-dir");
        }
        this.mRootDir = new File(rootDirPath);
        try {
            FileUtils.forceMkdir((File)this.mRootDir);
        }
        catch (IOException ex) {
            throw new BlobStoreException("Failed to make root directory", ex);
        }
    }

    @Override
    public List<IBlobContainer> listContainers() throws BlobStoreException {
        ArrayList<IBlobContainer> containers = new ArrayList<IBlobContainer>();
        if (this.mRootDir.exists()) {
            for (File f : this.mRootDir.listFiles(new TenantAwareContainerDirFilter())) {
                containers.add(new FileBlobContainer(this, f));
            }
        }
        return containers;
    }

    @Override
    public IBlobContainer getContainer(String name, boolean create) throws BlobStoreException {
        File containerDir = this.getContainerDir(name);
        if (!containerDir.exists()) {
            if (create) {
                try {
                    FileUtils.forceMkdir((File)containerDir);
                }
                catch (IOException ex) {
                    throw new BlobStoreException("Failed to make container directory: " + containerDir.getPath(), ex);
                }
            } else {
                return null;
            }
        }
        return new FileBlobContainer(this, containerDir);
    }

    @Override
    public void removeContainer(String name) throws BlobStoreException {
        File containerDir = this.getContainerDir(name);
        if (containerDir.exists()) {
            FileUtils.deleteQuietly((File)containerDir);
        }
    }

    private File getContainerDir(String containerName) {
        return new File(this.mRootDir, FileBlobStore.getTenantId() + "." + containerName);
    }

    static String getTenantId() {
        return (String)SubjectHelper.getSessionAttribute((Subject)SecurityUtils.getSubject(), (String)"tenant.id", String.class, (boolean)true);
    }

    @Override
    public void shutdown() throws BlobStoreException {
    }

    private static final class TenantAwareContainerDirFilter
    implements FileFilter {
        private final String mExpectedPrefix = FileBlobStore.getTenantId() + ".";

        private TenantAwareContainerDirFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() && !f.isHidden() && f.getName().startsWith(this.mExpectedPrefix);
        }
    }
}

