/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore.file;

import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlobStore;
import com.ibm.neo.blobstore.IBlobStoreFactory;
import com.ibm.neo.blobstore.file.FileBlobStore;
import com.ibm.neo.crypto.service.CryptoException;
import com.ibm.neo.crypto.service.CryptoService;
import com.ibm.neo.crypto.service.DefaultCryptoServiceFactory;
import com.ibm.neo.persist.PersistenceService;
import java.util.Properties;

public class FileBlobStoreFactory
implements IBlobStoreFactory {
    public static final String PROP_ROOT_DIRECTORY = "com.ibm.neo.blobstore.file.root-dir";

    @Override
    public IBlobStore create(Properties config) throws BlobStoreException {
        try {
            CryptoService crypto = new DefaultCryptoServiceFactory().getInstance(config);
            return new FileBlobStore(config, crypto);
        }
        catch (CryptoException ex) {
            throw new BlobStoreException.CryptoError("Failed to initialize CryptoService", ex);
        }
    }

    @Override
    public IBlobStore create(Properties config, PersistenceService persistenceService) throws BlobStoreException {
        return this.create(config);
    }
}

