/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore.ps;

import com.ibm.neo.blobstore.AbstractBlob;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.ps.PSBlobContainer;
import com.ibm.neo.crypto.service.CryptoException;
import com.ibm.neo.persist.IFile;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.QueryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PSBlob
extends AbstractBlob {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSBlob.class);
    private final IFile mFile;

    PSBlob(PSBlobContainer container, IFile f) {
        super(container, f.getId().getIdentifier(), f.getFilename(), f.getContentType(), f.getLength(), f.getUploadDate(), Boolean.TRUE.equals(f.getMetadataValue("compressed")), Boolean.TRUE.equals(f.getMetadataValue("encrypted")));
        this.mFile = f;
    }

    @Override
    public Set<String> getMetadataKeys() throws BlobStoreException {
        HashSet<String> keys = new HashSet<String>(this.mFile.getMetadataKeys());
        keys.remove("compressed");
        keys.remove("encrypted");
        return keys;
    }

    @Override
    public Object getMetadataValue(String key) throws BlobStoreException {
        return this.mFile.getMetadataValue(key);
    }

    @Override
    public void setMetadataValue(String key, Object value) throws BlobStoreException {
        if (key.equals("compressed")) {
            throw new IllegalArgumentException("Metadata key ('compressed') is reserved for internal use only");
        }
        if (key.equals("encrypted")) {
            throw new IllegalArgumentException("Metadata key ('encrypted') is reserved for internal use only");
        }
        this.mFile.setMetadataValue(key, value);
    }

    @Override
    public void saveMetadata() throws BlobStoreException {
        try {
            this.mFile.save();
        }
        catch (PersistenceException ex) {
            LOGGER.error("PersistenceException caught", (Throwable)ex);
            throw new BlobStoreException(ex);
        }
    }

    @Override
    public boolean exists() throws BlobStoreException {
        try {
            return this.mFile.getBucket().count(new QueryBuilder().equalTo("_id", (Object)this.mFile.getId()).toDocument()) > 0L;
        }
        catch (PersistenceException ex) {
            LOGGER.error("PersistenceException caught", (Throwable)ex);
            throw new BlobStoreException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream open() throws BlobStoreException, IOException {
        InputStream inputStream;
        block12: {
            if (!this.exists()) {
                throw new BlobStoreException.BlobNotFound(this.getContainer().getName(), this.getKey());
            }
            InputStream in = this.mFile.open();
            boolean closeStream = true;
            try {
                if (this.isEncrypted()) {
                    if (!this.getCrypto().isEnabled()) {
                        throw new BlobStoreException.CryptoNotSupported();
                    }
                    try {
                        in = this.getCrypto().decrypt(in);
                    }
                    catch (CryptoException ex) {
                        LOGGER.error("Failed to create decryption stream", (Throwable)ex);
                        throw new BlobStoreException("Failed to create decryption stream", ex);
                    }
                }
                if (this.isCompressed()) {
                    in = new GzipCompressorInputStream(in);
                }
                closeStream = false;
                inputStream = in;
                if (!closeStream) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (closeStream) {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                    throw throwable;
                }
                catch (PersistenceException ex) {
                    LOGGER.error("PersistenceException caught", (Throwable)ex);
                    throw new BlobStoreException(ex);
                }
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        return inputStream;
    }

    @Override
    public void remove() throws BlobStoreException {
        try {
            this.mFile.getBucket().remove(this.mFile.getId());
        }
        catch (PersistenceException ex) {
            LOGGER.error("PersistenceException caught", (Throwable)ex);
            throw new BlobStoreException(ex);
        }
    }
}

