/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore.ps;

import com.ibm.neo.blobstore.AbstractBlobContainer;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlob;
import com.ibm.neo.blobstore.ps.PSBlob;
import com.ibm.neo.blobstore.ps.PSBlobStore;
import com.ibm.neo.crypto.service.CryptoException;
import com.ibm.neo.io.GzipCompressingInputStream;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.IFile;
import com.ibm.neo.persist.IFileBucket;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ion.IONObjectId;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PSBlobContainer
extends AbstractBlobContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSBlobContainer.class);
    private final IFileBucket mBucket;

    PSBlobContainer(PSBlobStore store, String name, IFileBucket bucket) {
        super(store, name);
        this.mBucket = bucket;
    }

    @Override
    public boolean supportsCustomBlobKeys() {
        return false;
    }

    @Override
    public boolean exists() throws BlobStoreException {
        try {
            IDocumentDatabase db = this.mBucket.getDatabase();
            return db.collectionExists(this.getName() + ".files");
        }
        catch (PersistenceException ex) {
            LOGGER.error("PersistenceException caught", (Throwable)ex);
            throw new BlobStoreException(ex);
        }
    }

    @Override
    public Iterator<IBlob> iterator() {
        try {
            if (!this.exists()) {
                throw new BlobStoreException.ContainerNotFound(this.getName());
            }
            try {
                List files = this.mBucket.findAll();
                ArrayList<PSBlob> blobs = new ArrayList<PSBlob>(files.size());
                for (IFile f : files) {
                    blobs.add(new PSBlob(this, f));
                }
                return blobs.iterator();
            }
            catch (PersistenceException ex) {
                LOGGER.error("PersistenceException caught", (Throwable)ex);
                throw new BlobStoreException(ex);
            }
        }
        catch (BlobStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public List<IBlob> findFilename(String filename) throws BlobStoreException {
        if (!this.exists()) {
            throw new BlobStoreException.ContainerNotFound(this.getName());
        }
        try {
            List files = this.mBucket.find(filename);
            ArrayList<IBlob> blobs = new ArrayList<IBlob>(files.size());
            for (IFile f : files) {
                blobs.add(new PSBlob(this, f));
            }
            return blobs;
        }
        catch (PersistenceException ex) {
            LOGGER.error("PersistenceException caught", (Throwable)ex);
            throw new BlobStoreException(ex);
        }
    }

    @Override
    public IBlob get(String key) throws BlobStoreException {
        if (!this.exists()) {
            throw new BlobStoreException.ContainerNotFound(this.getName());
        }
        try {
            IONObjectId fileId = new IONObjectId(key);
            IFile file = null;
            try {
                file = this.mBucket.get(fileId);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
            if (null == file) {
                return null;
            }
            return new PSBlob(this, file);
        }
        catch (PersistenceException ex) {
            LOGGER.error("PersistenceException caught", (Throwable)ex);
            throw new BlobStoreException(ex);
        }
    }

    @Override
    public IBlob create(String key, String filename, String contentType, InputStream contentStream, boolean compress) throws BlobStoreException, IOException {
        throw new UnsupportedOperationException("Implementation does not support custom blob keys.");
    }

    @Override
    public IBlob create(String filename, String contentType, InputStream contentStream, boolean compress) throws BlobStoreException, IOException {
        if (!this.exists()) {
            throw new BlobStoreException.ContainerNotFound(this.getName());
        }
        boolean encrypt = this.shouldEncrypt();
        if (compress) {
            contentStream = new GzipCompressingInputStream(contentStream);
        }
        if (encrypt) {
            try {
                contentStream = this.getCrypto().encrypt(contentStream);
            }
            catch (CryptoException ex) {
                LOGGER.error("Failed to create encryption stream", (Throwable)ex);
                throw new BlobStoreException.CryptoError("Failed to create encryption stream", ex);
            }
        }
        LOGGER.info("Creating blob [filename={}, compress={}, encrypt={}]", new Object[]{filename, compress, encrypt});
        try {
            IFile file = this.mBucket.createFile(contentStream, filename, contentType);
            if (compress || encrypt) {
                file.setMetadataValue("compressed", (Object)compress);
                file.setMetadataValue("encrypted", (Object)encrypt);
                file.save();
            }
            PSBlob pSBlob = new PSBlob(this, file);
            return pSBlob;
        }
        catch (PersistenceException.MD5ChecksumMismatch ex) {
            LOGGER.error("MD5 checksum failure");
            throw new BlobStoreException.ChecksumMismatch();
        }
        catch (PersistenceException ex) {
            LOGGER.error("PersistenceException caught", (Throwable)ex);
            throw new BlobStoreException(ex);
        }
        finally {
            contentStream.close();
        }
    }

    @Override
    public void delete(String key) throws BlobStoreException {
        if (!this.exists()) {
            throw new BlobStoreException.ContainerNotFound(this.getName());
        }
        try {
            IONObjectId fileId = new IONObjectId(key);
            this.mBucket.remove(fileId);
        }
        catch (PersistenceException ex) {
            LOGGER.error("PersistenceException caught", (Throwable)ex);
            throw new BlobStoreException(ex);
        }
    }

    @Override
    public IBlob create(String filename, String contentType, InputStream contentStream, boolean compress, int secondsToLive) throws BlobStoreException, IOException {
        return this.create(null, filename, contentType, contentStream, compress, secondsToLive);
    }

    @Override
    public IBlob create(String key, String filename, String contentType, InputStream contentStream, boolean compress, int secondsToLive) throws BlobStoreException, IOException {
        throw new UnsupportedOperationException("Implementation does not support secondsToLive.");
    }
}

