/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore.ps;

import com.ibm.neo.blobstore.AbstractBlobStore;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlobContainer;
import com.ibm.neo.blobstore.ps.PSBlobContainer;
import com.ibm.neo.crypto.service.CryptoService;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.IFile;
import com.ibm.neo.persist.IFileBucket;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.security.SubjectHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PSBlobStore
extends AbstractBlobStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSBlobStore.class);
    static final String DOT_FILES = ".files";
    private final PersistenceService mPS;

    PSBlobStore(Properties config, CryptoService crypto, PersistenceService ps) throws BlobStoreException {
        super(config, crypto);
        this.mPS = ps;
    }

    @Override
    public List<IBlobContainer> listContainers() throws BlobStoreException {
        try {
            ArrayList<IBlobContainer> containers = new ArrayList<IBlobContainer>();
            IDocumentDatabase db = this.mPS.getTenantDatabase();
            for (String name : db.getCollectionNames()) {
                if (!name.endsWith(DOT_FILES)) continue;
                String bucketName = name.substring(0, name.length() - DOT_FILES.length());
                IFileBucket bucket = db.getFileBucket(bucketName);
                containers.add(new PSBlobContainer(this, bucketName, bucket));
            }
            return containers;
        }
        catch (PersistenceException ex) {
            LOGGER.error("PersistenceException caught", (Throwable)ex);
            throw new BlobStoreException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IBlobContainer getContainer(String name, boolean create) throws BlobStoreException {
        try {
            IDocumentDatabase db = this.mPS.getTenantDatabase();
            IFileBucket bucket = null;
            if (!db.collectionExists(name + DOT_FILES)) {
                if (!create) return null;
                bucket = db.getFileBucket(name);
                try {
                    ByteArrayInputStream emptyStream = new ByteArrayInputStream(new byte[0]);
                    IFile dummyFile = bucket.createFile((InputStream)emptyStream, "__dummy__", null);
                    bucket.remove(dummyFile.getId());
                    return new PSBlobContainer(this, name, bucket);
                }
                catch (PersistenceException ex) {
                    LOGGER.error("PersistenceException caught", (Throwable)ex);
                    throw new BlobStoreException(ex);
                }
            } else {
                bucket = db.getFileBucket(name);
            }
            return new PSBlobContainer(this, name, bucket);
        }
        catch (PersistenceException ex) {
            LOGGER.error("PersistenceException caught", (Throwable)ex);
            throw new BlobStoreException(ex);
        }
    }

    @Override
    public void removeContainer(String name) throws BlobStoreException {
        try {
            IDocumentDatabase db = this.mPS.getTenantDatabase();
            if (db.collectionExists(name + DOT_FILES)) {
                IFileBucket bucket = db.getFileBucket(name);
                bucket.drop();
            }
        }
        catch (PersistenceException ex) {
            LOGGER.error("PersistenceException caught", (Throwable)ex);
            throw new BlobStoreException(ex);
        }
    }

    @Override
    public void shutdown() throws BlobStoreException {
    }

    static String getTenantId() {
        return (String)SubjectHelper.getSessionAttribute((Subject)SecurityUtils.getSubject(), (String)"tenant.id", String.class, (boolean)true);
    }
}

