/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore.ps;

import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlobStore;
import com.ibm.neo.blobstore.IBlobStoreFactory;
import com.ibm.neo.blobstore.ps.PSBlobStore;
import com.ibm.neo.crypto.service.CryptoException;
import com.ibm.neo.crypto.service.CryptoService;
import com.ibm.neo.crypto.service.DefaultCryptoServiceFactory;
import com.ibm.neo.persist.PersistenceService;
import java.util.Properties;

public class PSBlobStoreFactory
implements IBlobStoreFactory {
    @Override
    public IBlobStore create(Properties config) throws BlobStoreException {
        PersistenceService ps = PersistenceService.getInstance();
        return this.create(config, ps);
    }

    @Override
    public IBlobStore create(Properties config, PersistenceService persistenceService) throws BlobStoreException {
        try {
            CryptoService crypto = new DefaultCryptoServiceFactory().getInstance(config);
            return new PSBlobStore(config, crypto, persistenceService);
        }
        catch (CryptoException ex) {
            throw new BlobStoreException.CryptoError("Failed to initialize CryptoService", ex);
        }
    }
}

