/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore.swift;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

class ExecutorServiceBatcher {
    private final ExecutorService mExecutor;
    private final int mBatchSize;
    private final ConcurrentLinkedQueue<Future<?>> mBatch = new ConcurrentLinkedQueue();

    public ExecutorServiceBatcher(ExecutorService executor, int batchSize) {
        this.mExecutor = executor;
        this.mBatchSize = batchSize;
    }

    public <T> Future<T> submit(Callable<T> task) throws ExecutionException, InterruptedException {
        Future<T> f = this.mExecutor.submit(task);
        this.mBatch.add(f);
        if (this.mBatch.size() >= this.mBatchSize) {
            this.joinBatch();
        }
        return f;
    }

    public void finish() throws ExecutionException, InterruptedException {
        this.joinBatch();
    }

    private void joinBatch() throws ExecutionException, InterruptedException {
        Future<?> f;
        while (null != (f = this.mBatch.poll())) {
            f.get();
        }
    }
}

