/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore.swift;

import org.apache.commons.lang.NullArgumentException;

class SegmentIdGenerator {
    private final char[] elements;

    public SegmentIdGenerator(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length must be > 0");
        }
        this.elements = new char[length];
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = 97;
        }
    }

    public SegmentIdGenerator(char[] initial) {
        if (null == initial) {
            throw new NullArgumentException("initial");
        }
        if (initial.length <= 0) {
            throw new IllegalArgumentException("initial.length must be > 0");
        }
        this.elements = new char[initial.length];
        for (int i = 0; i < this.elements.length; ++i) {
            if (initial[i] < 'a' || initial[i] > 'z') {
                throw new IllegalArgumentException("Invalid character (" + initial[i] + ") at position " + i);
            }
            this.elements[i] = initial[i];
        }
    }

    public String nextId() {
        String str = new String(this.elements);
        this.roll(this.elements.length - 1);
        return str;
    }

    private void roll(int index) {
        if (index < 0) {
            throw new IllegalStateException("Overflow");
        }
        if (this.elements[index] < 'z') {
            int n = index;
            this.elements[n] = (char)(this.elements[n] + '\u0001');
        } else {
            this.elements[index] = 97;
            this.roll(index - 1);
        }
    }
}

