/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore.swift;

import com.ibm.neo.blobstore.AbstractBlob;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.swift.SwiftBlobContainer;
import com.ibm.neo.blobstore.swift.SwiftBlobStore;
import com.ibm.wa.webclient.util.HttpDateParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.wink.common.internal.CaseInsensitiveMultivaluedMap;

class SwiftBlob
extends AbstractBlob {
    private static final String STRING_PREFIX = "string:";
    private static final String LONG_PREFIX = "long:";
    private static final String DOUBLE_PREFIX = "double:";
    private static final String BOOLEAN_PREFIX = "boolean:";
    private static final String DATE_PREFIX = "date:";
    private static final Set<String> INTERNAL_META_KEYS = new HashSet<String>();
    private final MultivaluedMap<String, String> mMetaHeaders;
    private String mManifest;

    SwiftBlob(SwiftBlobContainer container, String key, String filename, String contentType, long contentLength, String manifest, Date lastModification, boolean isCompressed, boolean isEncrypted) {
        super(container, key, filename, contentType, contentLength, lastModification, isCompressed, isEncrypted);
        INTERNAL_META_KEYS.add("X-Object-Meta-Filename");
        INTERNAL_META_KEYS.add("X-Object-Meta-Compressed");
        INTERNAL_META_KEYS.add("X-Object-Meta-Encrypted");
        this.mManifest = manifest;
        this.mMetaHeaders = new CaseInsensitiveMultivaluedMap();
        this.mMetaHeaders.putSingle((Object)"X-Object-Meta-Filename", (Object)filename);
        this.mMetaHeaders.putSingle((Object)"X-Object-Meta-Compressed", (Object)(isCompressed ? "true" : "false"));
        this.mMetaHeaders.putSingle((Object)"X-Object-Meta-Encrypted", (Object)(isEncrypted ? "true" : "false"));
    }

    protected SwiftBlob(SwiftBlobContainer container, String key, MultivaluedMap<String, String> headers) {
        super(container, key, (String)headers.getFirst((Object)"X-Object-Meta-Filename"), (String)headers.getFirst((Object)"Content-Type"), Long.parseLong((String)headers.getFirst((Object)"Content-Length")), SwiftBlob.parseHttpDate((String)headers.getFirst((Object)"Last-Modified")), Boolean.parseBoolean((String)headers.getFirst((Object)"X-Object-Meta-Compressed")), Boolean.parseBoolean((String)headers.getFirst((Object)"X-Object-Meta-Encrypted")));
        INTERNAL_META_KEYS.add("X-Object-Meta-Filename");
        INTERNAL_META_KEYS.add("X-Object-Meta-Compressed");
        INTERNAL_META_KEYS.add("X-Object-Meta-Encrypted");
        this.mMetaHeaders = SwiftBlob.filterMetaHeaders(headers);
        this.mManifest = (String)headers.getFirst((Object)"X-Object-Manifest");
    }

    @Override
    public boolean exists() throws BlobStoreException {
        return ((SwiftBlobStore)this.getStore()).blobExists(this.getContainer().getName(), this.getKey());
    }

    @Override
    public Set<String> getMetadataKeys() throws BlobStoreException {
        HashSet<String> keys = new HashSet<String>();
        for (String k : this.mMetaHeaders.keySet()) {
            if (null == k || !k.startsWith("X-Object-Meta-") || INTERNAL_META_KEYS.contains(k)) continue;
            keys.add(k.substring("X-Object-Meta-".length()).toLowerCase());
        }
        return keys;
    }

    @Override
    public Object getMetadataValue(String key) throws BlobStoreException {
        String headerName = "X-Object-Meta-" + key;
        String rawValue = (String)this.mMetaHeaders.getFirst((Object)headerName);
        if (null == rawValue || rawValue.isEmpty()) {
            return null;
        }
        if (rawValue.startsWith(STRING_PREFIX)) {
            return rawValue.substring(STRING_PREFIX.length());
        }
        if (rawValue.startsWith(LONG_PREFIX)) {
            return Long.parseLong(rawValue.substring(LONG_PREFIX.length()));
        }
        if (rawValue.startsWith(DOUBLE_PREFIX)) {
            return Double.parseDouble(rawValue.substring(DOUBLE_PREFIX.length()));
        }
        if (rawValue.startsWith(BOOLEAN_PREFIX)) {
            return Boolean.parseBoolean(rawValue.substring(BOOLEAN_PREFIX.length()));
        }
        if (rawValue.startsWith(DATE_PREFIX)) {
            return SwiftBlob.parseISO8601Timestamp(rawValue.substring(DATE_PREFIX.length()));
        }
        return rawValue;
    }

    @Override
    public void setMetadataValue(String key, Object value) throws BlobStoreException {
        if (key.equalsIgnoreCase("compressed")) {
            throw new IllegalArgumentException("Metadata key ('compressed') is reserved for internal use only");
        }
        if (key.equalsIgnoreCase("encrypted")) {
            throw new IllegalArgumentException("Metadata key ('encrypted') is reserved for internal use only");
        }
        if (key.equalsIgnoreCase("filename")) {
            throw new IllegalArgumentException("Metadata key ('filename') is reserved for internal use only");
        }
        String headerName = "X-Object-Meta-" + key;
        if (null == value) {
            this.mMetaHeaders.remove((Object)headerName);
        } else if (value instanceof String) {
            String rawValue = STRING_PREFIX + (String)value;
            this.mMetaHeaders.putSingle((Object)headerName, (Object)rawValue);
        } else if (value instanceof Number) {
            String rawValue = value instanceof Float || value instanceof Double ? DOUBLE_PREFIX + Double.toString(((Number)value).doubleValue()) : LONG_PREFIX + Long.toString(((Number)value).longValue());
            this.mMetaHeaders.putSingle((Object)headerName, (Object)rawValue);
        } else if (value instanceof Boolean) {
            String rawValue = BOOLEAN_PREFIX + Boolean.toString((Boolean)value);
            this.mMetaHeaders.putSingle((Object)headerName, (Object)rawValue);
        } else if (value instanceof Date) {
            String rawValue = DATE_PREFIX + SwiftBlob.formatISO8601Timestamp((Date)value);
            this.mMetaHeaders.putSingle((Object)headerName, (Object)rawValue);
        } else {
            throw new IllegalArgumentException("Unsupported value type");
        }
    }

    public URI getURI() throws BlobStoreException {
        return ((SwiftBlobStore)this.getStore()).getBlobURI(this.getContainer().getName(), this.getKey());
    }

    public List<URI> getSegmentURIs() throws BlobStoreException {
        return ((SwiftBlobStore)this.getStore()).listBlobSegmentURIs(this.getManifest());
    }

    public String getManifest() {
        return this.mManifest;
    }

    void setManifest(String manifest) {
        this.mManifest = manifest;
    }

    public MultivaluedMap<String, String> getMetaHeaders() {
        return this.mMetaHeaders;
    }

    @Override
    public void saveMetadata() throws BlobStoreException {
        ((SwiftBlobStore)this.getStore()).updateBlobHeaders(this.getContainer().getName(), this.getKey(), this.mMetaHeaders, this.mManifest);
    }

    @Override
    public InputStream open() throws BlobStoreException, IOException {
        return ((SwiftBlobStore)this.getStore()).openBlob(this.getContainer().getName(), this.getKey(), this.isCompressed(), this.isEncrypted());
    }

    @Override
    public void remove() throws BlobStoreException {
        ((SwiftBlobStore)this.getStore()).deleteBlob(this.getContainer().getName(), this.getKey());
    }

    private static MultivaluedMap<String, String> filterMetaHeaders(MultivaluedMap<String, String> headers) {
        CaseInsensitiveMultivaluedMap metaHeaders = new CaseInsensitiveMultivaluedMap();
        for (String headerName : headers.keySet()) {
            if (null == headerName || !headerName.startsWith("X-Object-Meta-")) continue;
            metaHeaders.putSingle((Object)headerName, headers.getFirst((Object)headerName));
        }
        return metaHeaders;
    }

    private static Date parseHttpDate(String dateStr) {
        try {
            return new HttpDateParser().parse(dateStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid HTTP Date: " + dateStr);
        }
    }
}

