/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore.swift;

import com.ibm.neo.blobstore.AbstractBlobContainer;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlob;
import com.ibm.neo.blobstore.swift.SwiftBlobStore;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

class SwiftBlobContainer
extends AbstractBlobContainer {
    SwiftBlobContainer(SwiftBlobStore store, String name) {
        super(store, name);
    }

    @Override
    public boolean supportsCustomBlobKeys() {
        return true;
    }

    @Override
    public boolean exists() throws BlobStoreException {
        return ((SwiftBlobStore)this.getStore()).containerExists(this.getName());
    }

    @Override
    public Iterator<IBlob> iterator() {
        try {
            return ((SwiftBlobStore)this.getStore()).blobs(this).iterator();
        }
        catch (BlobStoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public IBlob get(String key) throws BlobStoreException {
        return ((SwiftBlobStore)this.getStore()).getBlob(this, key);
    }

    @Override
    public List<IBlob> findFilename(String filename) throws BlobStoreException {
        return ((SwiftBlobStore)this.getStore()).findBlobFilename(this, filename);
    }

    @Override
    public IBlob create(String filename, String contentType, InputStream contentStream, boolean compress) throws BlobStoreException, IOException {
        return ((SwiftBlobStore)this.getStore()).createBlob(this, null, filename, contentType, contentStream, compress);
    }

    @Override
    public IBlob create(String key, String filename, String contentType, InputStream contentStream, boolean compress) throws BlobStoreException, IOException {
        return ((SwiftBlobStore)this.getStore()).createBlob(this, key, filename, contentType, contentStream, compress);
    }

    @Override
    public void delete(String key) throws BlobStoreException {
        ((SwiftBlobStore)this.getStore()).deleteBlob(this.getName(), key);
    }

    @Override
    public IBlob create(String filename, String contentType, InputStream contentStream, boolean compress, int secondsToLive) throws BlobStoreException, IOException {
        return ((SwiftBlobStore)this.getStore()).createBlob(this, null, filename, contentType, contentStream, compress, secondsToLive);
    }

    @Override
    public IBlob create(String key, String filename, String contentType, InputStream contentStream, boolean compress, int secondsToLive) throws BlobStoreException, IOException {
        return ((SwiftBlobStore)this.getStore()).createBlob(this, key, filename, contentType, contentStream, compress, secondsToLive);
    }
}

