/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore.swift;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.neo.blobstore.AbstractBlobStore;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlob;
import com.ibm.neo.blobstore.IBlobContainer;
import com.ibm.neo.blobstore.swift.ExecutorServiceBatcher;
import com.ibm.neo.blobstore.swift.SegmentIdGenerator;
import com.ibm.neo.blobstore.swift.SwiftAuthenticator;
import com.ibm.neo.blobstore.swift.SwiftBlob;
import com.ibm.neo.blobstore.swift.SwiftBlobContainer;
import com.ibm.neo.blobstore.swift.TempAuthAuthenticator;
import com.ibm.neo.crypto.service.CryptoException;
import com.ibm.neo.crypto.service.CryptoService;
import com.ibm.neo.io.FinalizerClosingInputStream;
import com.ibm.neo.io.GzipCompressingInputStream;
import com.ibm.neo.io.LimitedInputStream;
import com.ibm.neo.security.SubjectHelper;
import com.ibm.wa.webclient.util.PoolingHttpClientBuilder;
import com.ibm.wa.webclient.util.RestClientBuilder;
import com.ibm.wa.webclient.util.RuleBasedRetryStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.AutoRetryHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.concurrent.SubjectAwareExecutorService;
import org.apache.shiro.subject.Subject;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.ClientRuntimeException;
import org.apache.wink.client.Resource;
import org.apache.wink.client.RestClient;
import org.apache.wink.client.handlers.ClientHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SwiftBlobStore
extends AbstractBlobStore {
    private static final String DEFAULT_TEMP_DIR = FileUtils.getTempDirectoryPath();
    private static final long DEFAULT_MAX_SEGMENT_SIZE = 0x6400000L;
    private static final int DEFAULT_CONNECTION_TOTAL = 50;
    private static final int DEFAULT_MAX_CONNECTION_THREADS = 2;
    private static final int DEFAULT_CONNECTION_ROUTE_TOTAL = 50;
    private static final int DEFAULT_CONNECTION_TTL = 300000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    static final String PRIVATE_SCOPE = "private";
    static final String HEADER_X_CONTEXT = "X-Context";
    static final String HEADER_X_COPY_FROM = "X-Copy-From";
    static final String HEADER_X_SEARCH_ITEMS_COUNT = "X-Search-Items-Count";
    static final String HEADER_X_OBJECT_MANIFEST = "X-Object-Manifest";
    static final String HEADER_X_OBJECT_META = "X-Object-Meta-";
    static final String HEADER_X_OBJECT_META_FILENAME = "X-Object-Meta-Filename";
    static final String HEADER_X_OBJECT_META_COMPRESSED = "X-Object-Meta-Compressed";
    static final String HEADER_X_OBJECT_META_ENCRYPTED = "X-Object-Meta-Encrypted";
    static final String HEADER_X_DELETE_AFTER = "X-Delete-After";
    static final String HEADER_CONTENT_LENGTH = "Content-Length";
    static final String HEADER_CONTENT_TYPE = "Content-Type";
    static final String HEADER_ETAG = "ETag";
    static final String HEADER_LAST_MODIFIED = "Last-Modified";
    static final String HEADER_CONNECTION = "Connection";
    static final String KEEP_ALIVE = "Keep-Alive";
    static final int NO_TTL = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(SwiftBlobStore.class);
    private final File mTempDir;
    private final long mMaxSegmentSize;
    private final HttpClient mHttpClient;
    private final RestClient mRestClient;
    private final SwiftAuthenticator mAuthenticator;
    private int maxExecutorThreads;
    private final ExecutorService mExecutor;

    SwiftBlobStore(Properties config, CryptoService crypto) throws BlobStoreException {
        super(config, crypto);
        this.mTempDir = new File(config.getProperty("com.ibm.neo.blobstore.softlayer.temp-dir", DEFAULT_TEMP_DIR));
        try {
            FileUtils.forceMkdir((File)this.mTempDir);
        }
        catch (IOException ex) {
            throw new BlobStoreException("Unable to make temporary directory: " + this.mTempDir.getPath(), ex);
        }
        if (config.containsKey("com.ibm.neo.blobstore.softlayer.max-segment-size")) {
            try {
                this.mMaxSegmentSize = Long.parseLong(config.getProperty("com.ibm.neo.blobstore.softlayer.max-segment-size"));
            }
            catch (NumberFormatException ex) {
                throw new BlobStoreException("Illegal value for configuration property: com.ibm.neo.blobstore.softlayer.max-segment-size");
            }
        } else {
            this.mMaxSegmentSize = 0x6400000L;
        }
        this.mHttpClient = SwiftBlobStore.buildHttpClient(config);
        this.mAuthenticator = SwiftBlobStore.buildAuthenticator(this.mHttpClient, config);
        this.mRestClient = new RestClientBuilder().withFollowRedirects(false).withHttpClient(this.mHttpClient).withHandlers(new ClientHandler[]{this.mAuthenticator}).build();
        if (config.containsKey("com.ibm.neo.blobstore.softlayer.connection-threads")) {
            try {
                this.maxExecutorThreads = Integer.parseInt(config.getProperty("com.ibm.neo.blobstore.softlayer.connection-threads"));
            }
            catch (NumberFormatException ex) {
                throw new BlobStoreException("Illegal value for configuration property: com.ibm.neo.blobstore.softlayer.connection-threads");
            }
        } else {
            this.maxExecutorThreads = 2;
        }
        LOGGER.info("Starting daemon threads for SoftLayer Object Storage with {} threads and total connections {}", (Object)this.maxExecutorThreads, (Object)((PoolingClientConnectionManager)this.mHttpClient.getConnectionManager()).getMaxTotal());
        this.mExecutor = new SubjectAwareExecutorService((ExecutorService)new ThreadPoolExecutor(this.maxExecutorThreads, ((PoolingClientConnectionManager)this.mHttpClient.getConnectionManager()).getMaxTotal(), 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy()));
    }

    private static HttpClient buildHttpClient(Properties config) throws BlobStoreException {
        PoolingHttpClientBuilder builder = new PoolingHttpClientBuilder();
        if (config.containsKey("com.ibm.neo.blobstore.softlayer.connection-total")) {
            try {
                builder.withConnectionTotal(Integer.parseInt(config.getProperty("com.ibm.neo.blobstore.softlayer.connection-total").trim()));
            }
            catch (Exception ex) {
                throw new BlobStoreException.ConfigError(ex);
            }
        } else {
            builder.withConnectionTotal(50);
        }
        if (config.containsKey("com.ibm.neo.blobstore.softlayer.connection-route-total")) {
            try {
                builder.withConnectionRouteTotal(Integer.parseInt(config.getProperty("com.ibm.neo.blobstore.softlayer.connection-route-total").trim()));
            }
            catch (Exception ex) {
                throw new BlobStoreException.ConfigError(ex);
            }
        } else {
            builder.withConnectionRouteTotal(50);
        }
        if (config.containsKey("com.ibm.neo.blobstore.softlayer.connection-ttl")) {
            try {
                builder.withConnectionTTL(Integer.parseInt(config.getProperty("com.ibm.neo.blobstore.softlayer.connection-ttl").trim()));
            }
            catch (Exception ex) {
                throw new BlobStoreException.ConfigError(ex);
            }
        } else {
            builder.withConnectionTTL(300000);
        }
        if (config.containsKey("com.ibm.neo.blobstore.softlayer.connect-timeout")) {
            try {
                builder.withConnectTimeout(Integer.parseInt(config.getProperty("com.ibm.neo.blobstore.softlayer.connect-timeout").trim()));
            }
            catch (Exception ex) {
                throw new BlobStoreException.ConfigError(ex);
            }
        } else {
            builder.withConnectTimeout(30000);
        }
        if (config.containsKey("com.ibm.neo.blobstore.softlayer.so-timeout")) {
            try {
                builder.withSoTimeout(Integer.parseInt(config.getProperty("com.ibm.neo.blobstore.softlayer.so-timeout").trim()));
            }
            catch (Exception ex) {
                throw new BlobStoreException.ConfigError(ex);
            }
        }
        builder.withSchemePortTLSProtocols("https", 443, new String[]{"TLSv1.2"});
        HttpClient poolingClient = builder.build();
        RuleBasedRetryStrategy retryStrategy = new RuleBasedRetryStrategy(1000L).addRule(500, 2).addRule(502, 2).addRule(503, 5).addRule(504, 5);
        return new AutoRetryHttpClient(poolingClient, (ServiceUnavailableRetryStrategy)retryStrategy);
    }

    private static SwiftAuthenticator buildAuthenticator(HttpClient httpClient, Properties config) throws BlobStoreException {
        String authUrl = config.getProperty("com.ibm.neo.blobstore.softlayer.auth.url");
        if (authUrl == null) {
            throw new NullArgumentException("com.ibm.neo.blobstore.softlayer.auth.url");
        }
        String authUser = config.getProperty("com.ibm.neo.blobstore.softlayer.header.x-auth-user");
        if (authUser == null) {
            throw new NullArgumentException("com.ibm.neo.blobstore.softlayer.header.x-auth-user");
        }
        String authKey = config.getProperty("com.ibm.neo.blobstore.softlayer.header.x-auth-key");
        if (authKey == null) {
            throw new NullArgumentException("com.ibm.neo.blobstore.softlayer.header.x-auth-key");
        }
        String networkScope = config.getProperty("com.ibm.neo.blobstore.softlayer.network.scope", PRIVATE_SCOPE);
        return new TempAuthAuthenticator(httpClient, URI.create(authUrl), authUser, authKey, networkScope);
    }

    @Override
    public void shutdown() throws BlobStoreException {
        this.mExecutor.shutdown();
        HttpClientUtils.closeQuietly((HttpClient)this.mHttpClient);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<IBlobContainer> listContainers() throws BlobStoreException {
        ArrayList<IBlobContainer> arrayList;
        ClientResponse response;
        String tenantPrefix;
        block9: {
            tenantPrefix = SwiftBlobStore.getTenantId() + ".";
            response = null;
            URI accountURI = UriBuilder.fromUri((URI)this.mAuthenticator.getStorageURL()).queryParam("format", new Object[]{"json"}).queryParam("prefix", new Object[]{tenantPrefix}).build(new Object[0]);
            response = this.resource(accountURI).get();
            if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) != 0) {
                this.handleErrorResponse(response);
                break block9;
            }
            if (response.getStatusCode() != 204) break block9;
            List<IBlobContainer> list = Collections.emptyList();
            SwiftBlobStore.consumeContentQuietly(response);
            return list;
        }
        try {
            JSONArray jsonArr = JSONArray.parse((String)((String)response.getEntity(String.class)));
            ArrayList<IBlobContainer> containers = new ArrayList<IBlobContainer>();
            for (Object o : jsonArr) {
                JSONObject jsonContainer = (JSONObject)o;
                String name = (String)jsonContainer.get((Object)"name");
                if (!name.startsWith(tenantPrefix) || name.endsWith("segments")) continue;
                containers.add(new SwiftBlobContainer(this, name.substring(tenantPrefix.length())));
            }
            arrayList = containers;
        }
        catch (IOException ex) {
            try {
                LOGGER.error("IOException caught", (Throwable)ex);
                throw new BlobStoreException(ex);
                catch (ClientRuntimeException ex2) {
                    LOGGER.error("ClientRuntimeException caught", (Throwable)ex2);
                    Throwable cause = ExceptionUtils.getRootCause((Throwable)ex2);
                    if (null != cause) {
                        throw new BlobStoreException(cause);
                    }
                    throw new BlobStoreException(ex2);
                }
            }
            catch (Throwable throwable) {
                SwiftBlobStore.consumeContentQuietly(response);
                throw throwable;
            }
        }
        SwiftBlobStore.consumeContentQuietly(response);
        return arrayList;
    }

    @Override
    public IBlobContainer getContainer(String name, boolean create) throws BlobStoreException {
        if (!this.containerExists(name)) {
            if (create) {
                this.createContainer(name);
            } else {
                return null;
            }
        }
        if (!this.segmentsContainerExists(name)) {
            this.createSegmentsContainer(name);
        }
        return new SwiftBlobContainer(this, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeContainer(String containerName) throws BlobStoreException {
        URI containerURI = null;
        ClientResponse response = null;
        try {
            int i;
            containerURI = this.getContainerURI(containerName);
            if (this.exists(containerURI)) {
                for (i = 0; i < 5; ++i) {
                    this.clearContainer(containerURI);
                    response = this.resource(containerURI).delete();
                    if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) != 0) {
                        if (response.getStatusCode() == 404) break;
                        if (response.getStatusCode() == 409) {
                            LOGGER.warn("Conflict while deleting container: {}", (Object)containerURI);
                            continue;
                        }
                        this.handleErrorResponse(response);
                        continue;
                    }
                    LOGGER.trace("Deleted container: {}", (Object)containerURI);
                    break;
                }
            }
            if (!this.exists(containerURI = this.getSegmentsContainerURI(containerName))) return;
            i = 0;
            while (i < 5) {
                this.clearContainer(containerURI);
                response = this.resource(containerURI).delete();
                if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) == 0) {
                    LOGGER.trace("Deleted container: {}", (Object)containerURI);
                    return;
                }
                if (response.getStatusCode() == 404) {
                    return;
                }
                if (response.getStatusCode() == 409) {
                    LOGGER.warn("Conflict while deleting container: {}", (Object)containerURI);
                } else {
                    this.handleErrorResponse(response);
                }
                ++i;
            }
            return;
        }
        catch (ClientRuntimeException ex) {
            LOGGER.error("ClientRuntimeException caught", (Throwable)ex);
            Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
            if (null == cause) throw new BlobStoreException(ex);
            throw new BlobStoreException(cause);
        }
        finally {
            SwiftBlobStore.consumeContentQuietly(response);
        }
    }

    private void clearContainer(URI containerURI) throws BlobStoreException {
        ExecutorServiceBatcher batcher = new ExecutorServiceBatcher(this.mExecutor, 10);
        ObjectLister objects = new ObjectLister(containerURI);
        try {
            for (JSONObject obj : objects) {
                String name = (String)obj.get((Object)"name");
                final URI objectURI = UriBuilder.fromUri((URI)containerURI).path(name).build(new Object[0]);
                Callable<Object> task = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        LOGGER.trace("Deleting object: {}", (Object)objectURI);
                        SwiftBlobStore.this.delete(objectURI);
                        return null;
                    }
                };
                try {
                    batcher.submit(task);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                batcher.finish();
            }
            catch (InterruptedException i$) {}
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof BlobStoreException) {
                throw (BlobStoreException)ex.getCause();
            }
            throw new BlobStoreException("An unexpected error occured", ex.getCause());
        }
    }

    private void delete(URI uri) throws BlobStoreException {
        ClientResponse response;
        block6: {
            block7: {
                response = null;
                response = this.resource(uri).delete();
                if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) == 0) break block6;
                if (response.getStatusCode() != 404) break block7;
                SwiftBlobStore.consumeContentQuietly(response);
                return;
            }
            try {
                this.handleErrorResponse(response);
            }
            catch (ClientRuntimeException ex) {
                try {
                    LOGGER.error("ClientRuntimeException caught", (Throwable)ex);
                    Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
                    if (null != cause) {
                        throw new BlobStoreException(cause);
                    }
                    throw new BlobStoreException(ex);
                }
                catch (Throwable throwable) {
                    SwiftBlobStore.consumeContentQuietly(response);
                    throw throwable;
                }
            }
        }
        SwiftBlobStore.consumeContentQuietly(response);
    }

    private boolean exists(URI uri) throws BlobStoreException {
        ClientResponse response;
        block6: {
            block7: {
                response = null;
                response = this.resource(uri).head();
                if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) == 0) break block6;
                if (response.getStatusCode() != 404) break block7;
                boolean bl = false;
                SwiftBlobStore.consumeContentQuietly(response);
                return bl;
            }
            try {
                this.handleErrorResponse(response);
            }
            catch (ClientRuntimeException ex) {
                try {
                    LOGGER.error("ClientRuntimeException caught", (Throwable)ex);
                    Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
                    if (null != cause) {
                        throw new BlobStoreException(cause);
                    }
                    throw new BlobStoreException(ex);
                }
                catch (Throwable throwable) {
                    SwiftBlobStore.consumeContentQuietly(response);
                    throw throwable;
                }
            }
        }
        SwiftBlobStore.consumeContentQuietly(response);
        return true;
    }

    protected boolean containerExists(String containerName) throws BlobStoreException {
        URI containerURI = this.getContainerURI(containerName);
        return this.exists(containerURI);
    }

    private boolean segmentsContainerExists(String containerName) throws BlobStoreException {
        URI containerURI = this.getSegmentsContainerURI(containerName);
        return this.exists(containerURI);
    }

    protected boolean blobExists(String containerName, String blobKey) throws BlobStoreException {
        URI blobURI = this.getBlobURI(containerName, blobKey);
        return this.exists(blobURI);
    }

    private void createContainer(String containerName) throws BlobStoreException {
        URI containerURI = null;
        ClientResponse response = null;
        try {
            containerURI = this.getContainerURI(containerName);
            response = this.resource(containerURI).put(null);
            if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) != 0) {
                this.handleErrorResponse(response);
            }
            LOGGER.trace("Created container: {}", (Object)containerURI);
        }
        catch (ClientRuntimeException ex) {
            try {
                LOGGER.error("ClientRuntimeException caught", (Throwable)ex);
                Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
                if (null != cause) {
                    throw new BlobStoreException(cause);
                }
                throw new BlobStoreException(ex);
            }
            catch (Throwable throwable) {
                SwiftBlobStore.consumeContentQuietly(response);
                throw throwable;
            }
        }
        SwiftBlobStore.consumeContentQuietly(response);
    }

    private void createSegmentsContainer(String containerName) throws BlobStoreException {
        URI containerURI = null;
        ClientResponse response = null;
        try {
            containerURI = this.getSegmentsContainerURI(containerName);
            response = this.resource(containerURI).put(null);
            if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) != 0) {
                this.handleErrorResponse(response);
            }
            LOGGER.trace("Created segments container: {}", (Object)containerURI);
        }
        catch (ClientRuntimeException ex) {
            try {
                LOGGER.error("ClientRuntimeException caught", (Throwable)ex);
                Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
                if (null != cause) {
                    throw new BlobStoreException(cause);
                }
                throw new BlobStoreException(ex);
            }
            catch (Throwable throwable) {
                SwiftBlobStore.consumeContentQuietly(response);
                throw throwable;
            }
        }
        SwiftBlobStore.consumeContentQuietly(response);
    }

    protected Iterable<IBlob> blobs(SwiftBlobContainer container) throws BlobStoreException {
        URI containerURI = this.getContainerURI(container.getName());
        ObjectLister objects = new ObjectLister(containerURI);
        return new BlobLister(objects, container);
    }

    protected SwiftBlob getBlob(SwiftBlobContainer container, String blobKey) throws BlobStoreException {
        ClientResponse response;
        block10: {
            block11: {
                response = null;
                URI blobURI = this.getBlobURI(container.getName(), blobKey);
                response = this.resource(blobURI).head();
                if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) == 0) break block10;
                if (response.getStatusCode() != 404) break block11;
                SwiftBlob swiftBlob = null;
                SwiftBlobStore.consumeContentQuietly(response);
                return swiftBlob;
            }
            try {
                this.handleErrorResponse(response);
            }
            catch (ClientRuntimeException ex) {
                try {
                    LOGGER.error("ClientRuntimeException caught", (Throwable)ex);
                    Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
                    if (null != cause) {
                        throw new BlobStoreException(cause);
                    }
                    throw new BlobStoreException(ex);
                }
                catch (Throwable throwable) {
                    SwiftBlobStore.consumeContentQuietly(response);
                    throw throwable;
                }
            }
        }
        SwiftBlobStore.consumeContentQuietly(response);
        MultivaluedMap allHeaders = response.getHeaders();
        SwiftBlob blob = new SwiftBlob(container, blobKey, (MultivaluedMap<String, String>)allHeaders);
        int repairAttempt = 0;
        while (blob.getManifest() == null && blob.getContentLength() == 0L) {
            if (++repairAttempt > 5) {
                LOGGER.error("Timed out while waiting for blob manifest to be repaired");
                break;
            }
            if (!this.segmentsContainerExists(container.getName())) break;
            this.repairBlobManifest(blob);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            blob = this.getBlob(container, blobKey);
        }
        return blob;
    }

    /*
     * Loose catch block
     */
    protected List<IBlob> findBlobFilename(SwiftBlobContainer container, String filename) throws BlobStoreException {
        ClientResponse response;
        block13: {
            block12: {
                URI containerURI = this.getContainerURI(container.getName());
                response = null;
                response = this.resource(containerURI).get();
                if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) != 0) {
                    this.handleErrorResponse(response);
                    break block12;
                }
                if (response.getStatusCode() != 204) break block12;
                List<IBlob> list = Collections.emptyList();
                SwiftBlobStore.consumeContentQuietly(response);
                return list;
            }
            String searchCountStr = (String)response.getHeaders().getFirst((Object)HEADER_X_SEARCH_ITEMS_COUNT);
            int searchCount = 0;
            if (searchCountStr == null || (searchCount = Integer.parseInt(searchCountStr)) != 0) break block13;
            List<IBlob> list = Collections.emptyList();
            SwiftBlobStore.consumeContentQuietly(response);
            return list;
        }
        ArrayList<IBlob> blobs = new ArrayList<IBlob>();
        JSONArray jsonArr = JSONArray.parse((String)((String)response.getEntity(String.class)));
        SwiftBlobStore.consumeContentQuietly(response);
        for (Object o : jsonArr) {
            JSONObject jsonItem = (JSONObject)o;
            String blobKey = (String)jsonItem.get((Object)"name");
            SwiftBlob b = this.getBlob(container, blobKey);
            if (null == b || !b.getFilename().equals(filename)) continue;
            blobs.add(b);
        }
        ArrayList<IBlob> arrayList = blobs;
        SwiftBlobStore.consumeContentQuietly(response);
        return arrayList;
        {
            catch (IOException ex) {
                try {
                    try {
                        throw new BlobStoreException(ex);
                    }
                    catch (ClientRuntimeException ex2) {
                        LOGGER.error("ClientRuntimeException caught", (Throwable)ex2);
                        Throwable cause = ExceptionUtils.getRootCause((Throwable)ex2);
                        if (null != cause) {
                            throw new BlobStoreException(cause);
                        }
                        throw new BlobStoreException(ex2);
                    }
                }
                catch (Throwable throwable) {
                    SwiftBlobStore.consumeContentQuietly(response);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SwiftBlob createBlob(final SwiftBlobContainer container, String key, String filename, String contentType, InputStream contentStream, boolean compress, final int secondsToLive) throws BlobStoreException, IOException {
        String blobKey;
        boolean encrypt = this.shouldEncrypt();
        if (compress) {
            contentStream = new GzipCompressingInputStream(contentStream);
        }
        if (encrypt) {
            try {
                contentStream = this.getCrypto().encrypt(contentStream);
            }
            catch (CryptoException ex) {
                LOGGER.error("Failed to create encryption stream", (Throwable)ex);
                throw new BlobStoreException.CryptoError("Failed to create encryption stream", ex);
            }
        }
        LOGGER.info("Creating blob [key={}, filename={}, compress={}, encrypt={}]", new Object[]{key, filename, compress, encrypt});
        CountingInputStream countingStream = new CountingInputStream(contentStream);
        ArrayList<File> segmentFiles = new ArrayList<File>();
        ExecutorServiceBatcher batcher = new ExecutorServiceBatcher(this.mExecutor, 2);
        String manifest = null;
        if (null == key) {
            blobKey = UUID.randomUUID().toString();
        } else {
            blobKey = key;
            this.deleteBlob(container.getName(), blobKey);
        }
        try {
            SegmentIdGenerator idGen = new SegmentIdGenerator(3);
            while (true) {
                final String id = idGen.nextId();
                final File file = new File(this.mTempDir, blobKey + "_" + id);
                FileOutputStream out = null;
                try {
                    out = FileUtils.openOutputStream((File)file);
                    long len = IOUtils.copyLarge((InputStream)new LimitedInputStream((InputStream)countingStream, this.mMaxSegmentSize), (OutputStream)out);
                    ((OutputStream)out).close();
                    if (len > 0L) {
                        segmentFiles.add(file);
                        Callable<Object> task = new Callable<Object>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Object call() throws Exception {
                                try {
                                    SwiftBlobStore.this.putBlobSegment(container.getName(), blobKey, id, file, secondsToLive);
                                }
                                finally {
                                    file.delete();
                                }
                                return null;
                            }
                        };
                        try {
                            batcher.submit(task);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        catch (ExecutionException ex) {
                            if (ex.getCause() instanceof BlobStoreException) {
                                throw (BlobStoreException)ex.getCause();
                            }
                            throw new BlobStoreException("An unexpected error occured", ex.getCause());
                        }
                    }
                    file.delete();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)out);
                    continue;
                }
                break;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)countingStream);
        }
        URI blobURI = null;
        ClientResponse response = null;
        try {
            try {
                batcher.finish();
            }
            catch (InterruptedException file) {
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof BlobStoreException) {
                    throw (BlobStoreException)ex.getCause();
                }
                throw new BlobStoreException("An unexpected error occured", ex.getCause());
            }
            blobURI = this.getBlobURI(container.getName(), blobKey);
            manifest = String.format("%s.%s.segments/%s/", SwiftBlobStore.getTenantId(), container.getName(), blobKey);
            Resource resource = this.resource(blobURI).header(HEADER_CONTENT_TYPE, new String[]{contentType}).header(HEADER_X_OBJECT_MANIFEST, new String[]{manifest}).header(HEADER_X_OBJECT_META_FILENAME, new String[]{filename}).header(HEADER_X_OBJECT_META_COMPRESSED, new String[]{Boolean.toString(compress)}).header(HEADER_X_OBJECT_META_ENCRYPTED, new String[]{Boolean.toString(encrypt)});
            if (secondsToLive > 0) {
                resource = resource.header(HEADER_X_DELETE_AFTER, new String[]{Integer.toString(secondsToLive)});
            }
            if ((response = resource.put((Object)new byte[0])).getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) != 0) {
                if (response.getStatusCode() == 404) {
                    throw new BlobStoreException.ContainerNotFound(container.getName());
                }
                this.handleErrorResponse(response);
            }
            LOGGER.trace("Created blob: {}", (Object)blobURI);
        }
        catch (ClientRuntimeException ex) {
            try {
                LOGGER.error("ClientRuntimeException caught", (Throwable)ex);
                Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
                if (null != cause) {
                    throw new BlobStoreException(cause);
                }
                throw new BlobStoreException(ex);
            }
            catch (Throwable throwable) {
                SwiftBlobStore.consumeContentQuietly(response);
                for (File f : segmentFiles) {
                    f.delete();
                }
                throw throwable;
            }
        }
        SwiftBlobStore.consumeContentQuietly(response);
        for (File f : segmentFiles) {
            f.delete();
        }
        int count = 0;
        while (!this.blobExists(container.getName(), blobKey)) {
            try {
                LOGGER.debug("Waiting 1000 ms for blob to be visible: {}", (Object)blobURI);
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                break;
            }
            if (++count <= 5) continue;
            LOGGER.warn("Timeout occured while waiting for blob to be visible: {}", (Object)blobURI);
            break;
        }
        SwiftBlob blob = new SwiftBlob(container, blobKey, filename, contentType, countingStream.getByteCount(), manifest, new Date(), compress, encrypt);
        return blob;
    }

    private URI putBlobSegment(String containerName, String blobKey, String segmentId, File segmentFile, int secondsToLive) throws BlobStoreException, IOException {
        String localMd5 = SwiftBlobStore.md5Hex(segmentFile);
        int retries = 0;
        URI blobURI = null;
        ClientResponse response = null;
        try {
            block9: while (true) {
                blobURI = this.getBlobSegmentURI(containerName, blobKey, segmentId);
                Resource resource = this.resource(blobURI).header(HEADER_CONTENT_TYPE, new String[]{"application/octet-stream"}).header(HEADER_ETAG, new String[]{localMd5});
                if (secondsToLive > 0) {
                    resource = resource.header(HEADER_X_DELETE_AFTER, new String[]{Integer.toString(secondsToLive)});
                }
                LOGGER.info("Uploading blob segment: {}", (Object)blobURI);
                response = resource.put((Object)segmentFile);
                if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) == 0) break;
                switch (response.getStatusCode()) {
                    case 404: {
                        throw new BlobStoreException.ContainerNotFound(containerName);
                    }
                    case 422: {
                        if (++retries <= 3) {
                            LOGGER.warn("Retrying upload due to ETag conflict");
                            continue block9;
                        }
                        this.handleErrorResponse(response);
                        break;
                    }
                    case 408: {
                        if (++retries <= 3) {
                            LOGGER.warn("Retrying upload due to request timeout");
                            continue block9;
                        }
                        this.handleErrorResponse(response);
                        break;
                    }
                    default: {
                        this.handleErrorResponse(response);
                    }
                }
                SwiftBlobStore.consumeContentQuietly(response);
            }
        }
        catch (ClientRuntimeException ex) {
            try {
                LOGGER.error("ClientRuntimeException caught", (Throwable)ex);
                Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
                if (null != cause) {
                    throw new BlobStoreException(cause);
                }
                throw new BlobStoreException(ex);
            }
            catch (Throwable throwable) {
                SwiftBlobStore.consumeContentQuietly(response);
                throw throwable;
            }
        }
        SwiftBlobStore.consumeContentQuietly(response);
        LOGGER.trace("Created blob segment: {}", (Object)blobURI);
        return blobURI;
    }

    /*
     * Unable to fully structure code
     */
    protected void deleteBlob(String containerName, String blobKey) throws BlobStoreException {
        block10: {
            blobURI = null;
            response = null;
            manifest = null;
            blobURI = this.getBlobURI(containerName, blobKey);
            response = this.resource(blobURI).head();
            if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) == 0) ** GOTO lbl15
            if (response.getStatusCode() != 404) break block10;
            SwiftBlobStore.consumeContentQuietly(response);
            return;
        }
        try {
            block11: {
                this.handleErrorResponse(response);
                break block11;
lbl15:
                // 1 sources

                manifest = (String)response.getHeaders().getFirst((Object)"X-Object-Manifest");
            }
            SwiftBlobStore.consumeContentQuietly(response);
            if (null != manifest) {
                for (URI segmentUri : this.listBlobSegmentURIs(manifest)) {
                    response = this.resource(segmentUri).delete();
                    if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) != 0 && response.getStatusCode() != 404) {
                        this.handleErrorResponse(response);
                    }
                    SwiftBlobStore.LOGGER.trace("Deleted blob segment: {}", (Object)segmentUri);
                }
            }
            if ((response = this.resource(blobURI).delete()).getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) != 0 && response.getStatusCode() != 404) {
                this.handleErrorResponse(response);
            }
            SwiftBlobStore.LOGGER.trace("Deleted blob: {}", (Object)blobURI);
        }
        catch (ClientRuntimeException ex) {
            try {
                SwiftBlobStore.LOGGER.error("ClientRuntimeException caught", (Throwable)ex);
                cause = ExceptionUtils.getRootCause((Throwable)ex);
                if (null != cause) {
                    throw new BlobStoreException(cause);
                }
                throw new BlobStoreException(ex);
            }
            catch (Throwable var8_10) {
                SwiftBlobStore.consumeContentQuietly(response);
                throw var8_10;
            }
        }
        SwiftBlobStore.consumeContentQuietly(response);
    }

    final List<URI> listBlobSegmentURIs(String manifest) throws BlobStoreException {
        int slashPos = manifest.indexOf(47);
        if (-1 == slashPos) {
            throw new BlobStoreException("Bad manifest: " + manifest);
        }
        String manifestContainer = manifest.substring(0, slashPos);
        String manifestPrefix = manifest.substring(slashPos + 1);
        URI manifestUri = UriBuilder.fromUri((URI)this.mAuthenticator.getStorageURL()).path("{manifestContainer}").queryParam("path", new Object[]{manifestPrefix}).build(new Object[]{manifestContainer});
        ObjectLister segments = new ObjectLister(manifestUri);
        ArrayList<URI> result = new ArrayList<URI>();
        for (JSONObject obj : segments) {
            String name = (String)obj.get((Object)"name");
            if (!name.startsWith(manifestPrefix)) {
                LOGGER.warn("Manifest prefix ({}) incorrectly matched to '{}'.", (Object)manifestPrefix, (Object)name);
                continue;
            }
            URI segmentUri = UriBuilder.fromUri((URI)this.mAuthenticator.getStorageURL()).path("{manifestContainer}/{segmentName}").build(new Object[]{manifestContainer, name});
            result.add(segmentUri);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream openBlob(String containerName, String blobKey, boolean isCompressed, boolean isEncrypted) throws BlobStoreException, IOException {
        FinalizerClosingInputStream finalizerClosingInputStream;
        block14: {
            URI blobURI = null;
            ClientResponse response = null;
            blobURI = this.getBlobURI(containerName, blobKey);
            response = this.resource(blobURI).get();
            if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) != 0) {
                if (response.getStatusCode() == 404) {
                    throw new BlobStoreException.BlobNotFound(containerName, blobKey);
                }
                this.handleErrorResponse(response);
            }
            LOGGER.trace("Opening blob: {}", (Object)blobURI);
            Object in = new FinalizerClosingInputStream((InputStream)response.getEntity(InputStream.class));
            boolean closeStream = true;
            try {
                if (isEncrypted) {
                    if (!this.getCrypto().isEnabled()) {
                        throw new BlobStoreException.CryptoNotSupported();
                    }
                    try {
                        in = this.getCrypto().decrypt((InputStream)in);
                    }
                    catch (CryptoException ex) {
                        LOGGER.error("Failed to create decryption stream", (Throwable)ex);
                        throw new BlobStoreException("Failed to create decryption stream", ex);
                    }
                }
                if (isCompressed) {
                    in = new GzipCompressorInputStream((InputStream)in);
                }
                closeStream = false;
                finalizerClosingInputStream = in;
                if (!closeStream) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (closeStream) {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                    throw throwable;
                }
                catch (ClientRuntimeException ex) {
                    LOGGER.error("ClientRuntimeException caught", (Throwable)ex);
                    Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
                    if (null != cause) {
                        throw new BlobStoreException(cause);
                    }
                    throw new BlobStoreException(ex);
                }
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        return finalizerClosingInputStream;
    }

    protected void updateBlobHeaders(String containerName, String blobKey, MultivaluedMap<String, String> metaHeaders, String manifest) throws BlobStoreException {
        ClientResponse response = null;
        try {
            URI blobURI = this.getBlobURI(containerName, blobKey);
            Resource res = this.resource(blobURI);
            for (String headerName : metaHeaders.keySet()) {
                String value = (String)metaHeaders.getFirst((Object)headerName);
                res = res.header(headerName, new String[]{value});
            }
            if (null != manifest) {
                res = res.header(HEADER_X_OBJECT_MANIFEST, new String[]{manifest});
            }
            if ((response = res.post(null)).getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) != 0) {
                if (response.getStatusCode() == 404) {
                    throw new BlobStoreException.BlobNotFound(containerName, blobKey);
                }
                this.handleErrorResponse(response);
            }
            LOGGER.trace("Updated headers for blob: {}", (Object)blobURI);
        }
        catch (ClientRuntimeException ex) {
            try {
                LOGGER.error("ClientRuntimeException caught", (Throwable)ex);
                Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
                if (null != cause) {
                    throw new BlobStoreException(cause);
                }
                throw new BlobStoreException(ex);
            }
            catch (Throwable throwable) {
                SwiftBlobStore.consumeContentQuietly(response);
                throw throwable;
            }
        }
        SwiftBlobStore.consumeContentQuietly(response);
    }

    protected final void repairBlobManifest(SwiftBlob blob) throws BlobStoreException {
        String containerName = blob.getContainer().getName();
        String blobKey = blob.getKey();
        MultivaluedMap<String, String> metaHeaders = blob.getMetaHeaders();
        LOGGER.warn("Repairing manifest metadata for segmented blob '{}/{}'", (Object)containerName, (Object)blobKey);
        String manifest = String.format("%s.%s.segments/%s/", SwiftBlobStore.getTenantId(), containerName, blobKey);
        this.updateBlobHeaders(containerName, blobKey, metaHeaders, manifest);
    }

    final Resource resource(URI uri) throws BlobStoreException {
        return this.mRestClient.resource(uri).header(HEADER_CONNECTION, new String[]{KEEP_ALIVE}).accept(new String[]{"application/json"});
    }

    final URI getContainerURI(String containerName) throws BlobStoreException {
        return UriBuilder.fromUri((URI)this.mAuthenticator.getStorageURL()).path("{tenantId}.{containerName}").build(new Object[]{SwiftBlobStore.getTenantId(), containerName});
    }

    final URI getSegmentsContainerURI(String containerName) throws BlobStoreException {
        return UriBuilder.fromUri((URI)this.mAuthenticator.getStorageURL()).path("{tenantId}.{containerName}.segments").build(new Object[]{SwiftBlobStore.getTenantId(), containerName});
    }

    final URI getBlobURI(String containerName, String blobKey) throws BlobStoreException {
        return UriBuilder.fromUri((URI)this.mAuthenticator.getStorageURL()).path("{tenantId}.{containerName}/{blobKey}").build(new Object[]{SwiftBlobStore.getTenantId(), containerName, blobKey});
    }

    final URI getBlobSegmentURI(String containerName, String blobKey, String segmentId) throws BlobStoreException {
        return UriBuilder.fromUri((URI)this.mAuthenticator.getStorageURL()).path("{tenantId}.{containerName}.segments/{blobKey}/{segmentId}").build(new Object[]{SwiftBlobStore.getTenantId(), containerName, blobKey, segmentId});
    }

    private void handleErrorResponse(ClientResponse response) throws BlobStoreException {
        String errorBody = (String)response.getEntity(String.class);
        LOGGER.error("Request to Swift failed [status={}, message={}]:\n{}", new Object[]{response.getStatusCode(), response.getMessage(), errorBody});
        throw new BlobStoreException("Request to Swift failed (status " + response.getStatusCode() + "): " + response.getMessage());
    }

    private static void consumeContentQuietly(ClientResponse response) {
        if (null != response) {
            try {
                response.consumeContent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String md5Hex(File f) throws IOException {
        FileInputStream in = FileUtils.openInputStream((File)f);
        try {
            String string = DigestUtils.md5Hex((InputStream)in);
            return string;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private static String getTenantId() {
        return (String)SubjectHelper.getSessionAttribute((Subject)SecurityUtils.getSubject(), (String)"tenant.id", String.class, (boolean)true);
    }

    protected SwiftBlob createBlob(SwiftBlobContainer container, String key, String filename, String contentType, InputStream contentStream, boolean compress) throws BlobStoreException, IOException {
        return this.createBlob(container, key, filename, contentType, contentStream, compress, -1);
    }

    private final class BlobLister
    implements Iterable<IBlob> {
        private final Iterable<JSONObject> mObjects;
        private final SwiftBlobContainer mContainer;

        public BlobLister(Iterable<JSONObject> objects, SwiftBlobContainer container) {
            this.mObjects = objects;
            this.mContainer = container;
        }

        @Override
        public Iterator<IBlob> iterator() {
            return new BlobIter();
        }

        private final class BlobIter
        implements Iterator<IBlob> {
            private final Iterator<JSONObject> mObjectIter;
            private IBlob mNextBlob = null;

            BlobIter() {
                this.mObjectIter = BlobLister.this.mObjects.iterator();
                while (null == this.mNextBlob && this.mObjectIter.hasNext()) {
                    IBlob b = this.object2Blob(this.mObjectIter.next());
                    if (null == b) continue;
                    this.mNextBlob = b;
                }
            }

            @Override
            public boolean hasNext() {
                return null != this.mNextBlob;
            }

            @Override
            public IBlob next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IBlob nextBlob = this.mNextBlob;
                this.mNextBlob = null;
                while (null == this.mNextBlob && this.mObjectIter.hasNext()) {
                    IBlob b = this.object2Blob(this.mObjectIter.next());
                    if (null == b) continue;
                    this.mNextBlob = b;
                }
                return nextBlob;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private IBlob object2Blob(JSONObject obj) {
                try {
                    String blobKey = (String)obj.get((Object)"name");
                    return SwiftBlobStore.this.getBlob(BlobLister.this.mContainer, blobKey);
                }
                catch (BlobStoreException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public class ObjectLister
    implements Iterable<JSONObject> {
        private final URI mContainerURI;

        public ObjectLister(URI containerURI) {
            this.mContainerURI = containerURI;
        }

        @Override
        public Iterator<JSONObject> iterator() {
            return new MultiPageIter();
        }

        private final class PageIter
        implements Iterator<JSONObject> {
            private final JSONArray mContentArray;
            private int mNextIndex = -1;
            private JSONObject mNextEntry = null;

            PageIter(JSONArray contentArray) {
                this.mContentArray = contentArray;
                while (null == this.mNextEntry && ++this.mNextIndex < this.mContentArray.size()) {
                    this.mNextEntry = (JSONObject)this.mContentArray.get(this.mNextIndex);
                }
            }

            @Override
            public boolean hasNext() {
                return this.mNextIndex < this.mContentArray.size() && null != this.mNextEntry;
            }

            @Override
            public JSONObject next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                JSONObject result = this.mNextEntry;
                this.mNextEntry = null;
                while (null == this.mNextEntry && ++this.mNextIndex < this.mContentArray.size()) {
                    this.mNextEntry = (JSONObject)this.mContentArray.get(this.mNextIndex);
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private final class MultiPageIter
        implements Iterator<JSONObject> {
            private boolean mReachedEnd = false;
            private PageIter mCurrentPage = null;
            private String mNextMarker = null;
            private boolean hasReturnedPage = false;

            MultiPageIter() {
            }

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean nextPage() {
                boolean bl;
                JSONArray jsonArr;
                ClientResponse response;
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                UriBuilder builder = UriBuilder.fromUri((URI)ObjectLister.this.mContainerURI);
                                if (null != this.mNextMarker) {
                                    builder = builder.queryParam("marker", new Object[]{this.mNextMarker});
                                }
                                response = null;
                                response = SwiftBlobStore.this.resource(builder.build(new Object[0])).get();
                                if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) == 0) break block11;
                                this.mReachedEnd = true;
                                boolean bl2 = false;
                                SwiftBlobStore.consumeContentQuietly(response);
                                return bl2;
                            }
                            if (response.getStatusCode() != 204 && response.getStatusCode() != 404) break block12;
                            this.mReachedEnd = true;
                            boolean bl3 = false;
                            SwiftBlobStore.consumeContentQuietly(response);
                            return bl3;
                        }
                        jsonArr = JSONArray.parse((String)((String)response.getEntity(String.class)));
                        if (jsonArr.size() > 0) {
                            JSONObject lastElem = (JSONObject)jsonArr.get(jsonArr.size() - 1);
                            this.mNextMarker = (String)lastElem.get((Object)"name");
                            break block13;
                        }
                        this.mReachedEnd = true;
                        boolean bl4 = false;
                        SwiftBlobStore.consumeContentQuietly(response);
                        return bl4;
                    }
                    if (jsonArr.size() != 1 || !this.hasReturnedPage) break block14;
                    this.mReachedEnd = true;
                    this.mCurrentPage = null;
                    boolean bl5 = false;
                    SwiftBlobStore.consumeContentQuietly(response);
                    return bl5;
                }
                try {
                    this.hasReturnedPage = true;
                    this.mCurrentPage = new PageIter(jsonArr);
                    bl = true;
                }
                catch (IOException ex) {
                    try {
                        LOGGER.error("IOException caught", (Throwable)ex);
                        throw new RuntimeException("Malformed JSON response", ex);
                        catch (BlobStoreException ex2) {
                            LOGGER.error("Failed to fetch next page", (Throwable)ex2);
                            throw new RuntimeException("Failed to fetch next page", ex2);
                        }
                    }
                    catch (Throwable throwable) {
                        SwiftBlobStore.consumeContentQuietly(response);
                        throw throwable;
                    }
                }
                SwiftBlobStore.consumeContentQuietly(response);
                return bl;
            }

            @Override
            public boolean hasNext() {
                if (this.mReachedEnd) {
                    return false;
                }
                if (!(null != this.mCurrentPage && this.mCurrentPage.hasNext() || this.nextPage())) {
                    return false;
                }
                return this.mCurrentPage.hasNext();
            }

            @Override
            public JSONObject next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.mCurrentPage.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

