/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore.swift;

import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.IBlobStore;
import com.ibm.neo.blobstore.IBlobStoreFactory;
import com.ibm.neo.blobstore.swift.SwiftBlobStore;
import com.ibm.neo.crypto.service.CryptoException;
import com.ibm.neo.crypto.service.CryptoService;
import com.ibm.neo.crypto.service.DefaultCryptoServiceFactory;
import com.ibm.neo.persist.PersistenceService;
import java.util.Properties;

public class SwiftBlobStoreFactory
implements IBlobStoreFactory {
    public static final String PROP_AUTH_URL = "com.ibm.neo.blobstore.softlayer.auth.url";
    public static final String PROP_NETWORK_SCOPE = "com.ibm.neo.blobstore.softlayer.network.scope";
    public static final String PROP_X_AUTH_USER = "com.ibm.neo.blobstore.softlayer.header.x-auth-user";
    public static final String PROP_X_AUTH_KEY = "com.ibm.neo.blobstore.softlayer.header.x-auth-key";
    public static final String PROP_TEMP_DIR = "com.ibm.neo.blobstore.softlayer.temp-dir";
    public static final String PROP_MAX_SEGMENT_SIZE = "com.ibm.neo.blobstore.softlayer.max-segment-size";
    public static final String PROP_CONNECTION_TOTAL = "com.ibm.neo.blobstore.softlayer.connection-total";
    public static final String PROP_CONNECTION_THREADS = "com.ibm.neo.blobstore.softlayer.connection-threads";
    public static final String PROP_CONNECTION_ROUTE_TOTAL = "com.ibm.neo.blobstore.softlayer.connection-route-total";
    public static final String PROP_CONNECTION_TTL = "com.ibm.neo.blobstore.softlayer.connection-ttl";
    public static final String PROP_CONNECT_TIMEOUT = "com.ibm.neo.blobstore.softlayer.connect-timeout";
    public static final String PROP_SO_TIMEOUT = "com.ibm.neo.blobstore.softlayer.so-timeout";

    @Override
    public IBlobStore create(Properties config) throws BlobStoreException {
        try {
            CryptoService crypto = new DefaultCryptoServiceFactory().getInstance(config);
            return new SwiftBlobStore(config, crypto);
        }
        catch (CryptoException ex) {
            throw new BlobStoreException.CryptoError("Failed to initialize CryptoService", ex);
        }
    }

    @Override
    public IBlobStore create(Properties config, PersistenceService persistenceService) throws BlobStoreException {
        return this.create(config);
    }
}

