/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore.swift;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.blobstore.BlobStoreException;
import com.ibm.neo.blobstore.swift.SwiftAuthenticator;
import com.ibm.wa.webclient.util.RestClientBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.client.HttpClient;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.ClientRuntimeException;
import org.apache.wink.client.RestClient;
import org.apache.wink.client.handlers.HandlerContext;
import org.apache.wink.common.http.HttpStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TempAuthAuthenticator
implements SwiftAuthenticator {
    static final String HEADER_X_AUTH_USER = "X-Auth-User";
    static final String HEADER_X_AUTH_KEY = "X-Auth-Key";
    static final String HEADER_X_AUTH_TOKEN = "X-Auth-Token";
    static final String HEADER_X_AUTH_TOKEN_EXPIRES = "X-Auth-Token-Expires";
    private static final Logger LOGGER = LoggerFactory.getLogger(TempAuthAuthenticator.class);
    private final RestClient mClient;
    private final URI mAuthURL;
    private final String mAuthUser;
    private final String mAuthKey;
    private final String mNetworkScope;
    private URI mStorageURL;
    private String mAuthToken;
    private long mAuthExpires;
    private long mLastAuthTimeNanos;

    public TempAuthAuthenticator(HttpClient httpClient, URI authURL, String authUser, String authKey, String networkScope) {
        this.mClient = new RestClientBuilder().withFollowRedirects(false).withHttpClient(httpClient).build();
        this.mAuthURL = authURL;
        this.mAuthUser = authUser;
        this.mAuthKey = authKey;
        this.mNetworkScope = networkScope;
    }

    @Override
    public synchronized URI getStorageURL() throws BlobStoreException {
        this.authenticateIfRequired();
        return this.mStorageURL;
    }

    @Override
    public synchronized String getAuthToken() throws BlobStoreException {
        this.authenticateIfRequired();
        return this.mAuthToken;
    }

    @Override
    public synchronized void forceRenew() throws BlobStoreException {
        this.authenticate();
    }

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        request.getHeaders().putSingle((Object)HEADER_X_AUTH_TOKEN, (Object)this.getAuthToken());
        ClientResponse response = context.doChain(request);
        if (response.getStatusCode() == HttpStatus.UNAUTHORIZED.getCode()) {
            this.forceRenew();
            request.getHeaders().putSingle((Object)HEADER_X_AUTH_TOKEN, (Object)this.getAuthToken());
            response = context.doChain(request);
        }
        return response;
    }

    private void authenticateIfRequired() throws BlobStoreException {
        long secondsSinceLastAuth;
        if (null == this.mAuthToken) {
            this.authenticate();
        }
        if ((secondsSinceLastAuth = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.mLastAuthTimeNanos)) > 3L * this.mAuthExpires / 4L) {
            this.authenticate();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void authenticate() throws BlobStoreException {
        ClientResponse response = null;
        LOGGER.info("Authenticating user '{}' against URL '{}'", (Object)this.mAuthUser, (Object)this.mAuthURL);
        try {
            response = this.mClient.resource(this.mAuthURL).header(HEADER_X_AUTH_USER, new String[]{this.mAuthUser}).header(HEADER_X_AUTH_KEY, new String[]{this.mAuthKey}).accept(new String[]{"application/json"}).get();
            if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SUCCESSFUL) != 0) {
                if (response.getStatusCode() == 401) {
                    LOGGER.error("Authentication request failed: Credentials were rejected");
                    throw new BlobStoreException("Authentication request failed: Credentials were rejected");
                }
                throw new BlobStoreException("Authentication request failed (status " + response.getStatusCode() + "): " + response.getMessage());
            }
            this.mStorageURL = URI.create((String)response.getHeaders().getFirst((Object)"x-storage-url"));
            String authPayload = (String)response.getEntity(String.class);
            if (StringUtils.isNotEmpty((String)authPayload)) {
                JSONObject jobj = JSONObject.parse((String)((String)response.getEntity(String.class)));
                if (!jobj.containsKey((Object)"storage")) {
                    throw new BlobStoreException("Unable to resolve storage URL");
                }
                JSONObject storage = (JSONObject)jobj.get((Object)"storage");
                String storageStr = (String)storage.get((Object)this.mNetworkScope);
                if (null == storageStr) {
                    throw new BlobStoreException("Unable to resolve storage URL for network scope: " + this.mNetworkScope);
                }
                this.mStorageURL = URI.create(storageStr);
            }
        }
        catch (IOException ex) {
            try {
                LOGGER.error("IOException caught", (Throwable)ex);
                throw new BlobStoreException(ex);
                catch (ClientRuntimeException ex2) {
                    Throwable cause = ExceptionUtils.getRootCause((Throwable)ex2);
                    if (null != cause) {
                        throw new BlobStoreException(cause);
                    }
                    throw new BlobStoreException(ex2);
                }
            }
            catch (Throwable throwable) {
                TempAuthAuthenticator.consumeContentQuietly(response);
                throw throwable;
            }
        }
        TempAuthAuthenticator.consumeContentQuietly(response);
        MultivaluedMap headers = response.getHeaders();
        this.mAuthToken = (String)headers.getFirst((Object)HEADER_X_AUTH_TOKEN);
        if (null == this.mAuthToken) {
            throw new BlobStoreException("Missing required header: X-Auth-Token");
        }
        try {
            this.mAuthExpires = Long.parseLong((String)headers.getFirst((Object)HEADER_X_AUTH_TOKEN_EXPIRES));
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Failed to parse header: X-Auth-Token-Expires");
            this.mAuthExpires = TimeUnit.HOURS.toSeconds(5L);
        }
        this.mLastAuthTimeNanos = System.nanoTime();
    }

    private static void consumeContentQuietly(ClientResponse response) {
        if (null != response) {
            try {
                response.consumeContent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

