/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.blobstore.swift;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.handlers.HandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WinkRequestLoggerClientHandler
implements ClientHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(WinkRequestLoggerClientHandler.class);

    WinkRequestLoggerClientHandler() {
    }

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        ClientResponse response = context.doChain(request);
        if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.CLIENT_ERROR) == 0) {
            if (response.getStatusCode() == 404 || response.getStatusCode() == 409) {
                return response;
            }
            StringBuilder builder = new StringBuilder();
            WinkRequestLoggerClientHandler.appendRequestLogMessage(builder, request);
            WinkRequestLoggerClientHandler.appendResponseLogMessage(builder, response);
            LOGGER.warn(builder.toString());
        } else if (response.getStatusType().getFamily().compareTo((Enum)Response.Status.Family.SERVER_ERROR) == 0) {
            StringBuilder builder = new StringBuilder();
            WinkRequestLoggerClientHandler.appendRequestLogMessage(builder, request);
            WinkRequestLoggerClientHandler.appendResponseLogMessage(builder, response);
            LOGGER.error(builder.toString());
        } else if (LOGGER.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            WinkRequestLoggerClientHandler.appendRequestLogMessage(builder, request);
            WinkRequestLoggerClientHandler.appendResponseLogMessage(builder, response);
            LOGGER.debug(builder.toString());
        }
        return response;
    }

    private static void appendRequestLogMessage(StringBuilder builder, ClientRequest request) {
        builder.append(String.format("[HTTP REQUEST]%n", new Object[0]));
        builder.append(String.format("%s %s HTTP/1.1%n", request.getMethod(), request.getURI()));
        for (Map.Entry headers : request.getHeaders().entrySet()) {
            builder.append(String.format("%s: %s%n", headers.getKey(), ((List)headers.getValue()).get(0)));
        }
    }

    private static void appendResponseLogMessage(StringBuilder builder, ClientResponse response) {
        builder.append(String.format("[HTTP RESPONSE]%n", new Object[0]));
        builder.append(String.format("Status: %d, Message: %s%n", response.getStatusCode(), response.getMessage()));
        for (Map.Entry headers : response.getHeaders().entrySet()) {
            builder.append(String.format("%s: %s%n", headers.getKey(), ((List)headers.getValue()).get(0)));
        }
    }
}

