/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.autorestutil;

import com.ibm.cognos.autorestutil.DDPBEKey;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.GOST28147Parameters;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import org.bouncycastle.asn1.pkcs.CertBag;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedData;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.MacData;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Pfx;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.SafeBag;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.util.DigestFactory;
import org.bouncycastle.jcajce.PKCS12Key;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import org.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import org.bouncycastle.jce.interfaces.BCKeyStore;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class DDPKCS12KeyStoreProvider
extends KeyStoreSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers,
BCKeyStore {
    static final String PKCS12_MAX_IT_COUNT_PROPERTY = "org.bouncycastle.pkcs12.max_it_count";
    private static final int MIN_ITERATIONS = 1024;
    private static final f keySizeProvider = new f();
    private static Method initMethod;
    private static Method doFinalMethod;
    private static Method updateMethod;
    private g keys = new g();
    private Hashtable<String, String> localIds = new Hashtable();
    private g certs = new g();
    private Hashtable<c, Certificate> chainCerts = new Hashtable();
    private Hashtable keyCerts = new Hashtable();
    static final int NULL = 0;
    static final int CERTIFICATE = 1;
    static final int KEY = 2;
    static final int SECRET = 3;
    static final int SEALED = 4;
    static final int KEY_PRIVATE = 0;
    static final int KEY_PUBLIC = 1;
    static final int KEY_SECRET = 2;
    protected SecureRandom random = new SecureRandom();
    private CertificateFactory certFact;
    protected ASN1ObjectIdentifier keyAlgorithm;
    protected ASN1ObjectIdentifier certAlgorithm;
    private AlgorithmIdentifier macAlgorithm = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, (ASN1Encodable)DERNull.INSTANCE);
    private int itCount = 1024;

    public DDPKCS12KeyStoreProvider() {
        this(null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd40BitRC2_CBC);
    }

    public DDPKCS12KeyStoreProvider(Provider provider, ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier2) {
        this.keyAlgorithm = aSN1ObjectIdentifier;
        this.certAlgorithm = aSN1ObjectIdentifier2;
        try {
            this.certFact = provider != null ? CertificateFactory.getInstance("X.509", provider) : CertificateFactory.getInstance("X.509");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("can't create cert factory - " + exception.toString());
        }
    }

    private SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            return new SubjectKeyIdentifier(DDPKCS12KeyStoreProvider.getDigest(subjectPublicKeyInfo));
        }
        catch (Exception exception) {
            throw new RuntimeException("error creating key");
        }
    }

    private static byte[] getDigest(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        Digest digest = DigestFactory.createSHA1();
        byte[] byArray = new byte[digest.getDigestSize()];
        byte[] byArray2 = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        digest.update(byArray2, 0, byArray2.length);
        digest.doFinal(byArray, 0);
        return byArray;
    }

    public void setRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    public Enumeration engineAliases() {
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Enumeration enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.keys();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.certs.get(string) != null || this.keys.get(string) != null;
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        Key key = (Key)this.keys.remove(string);
        Certificate certificate = (Certificate)this.certs.remove(string);
        if (certificate != null) {
            this.chainCerts.remove(new c(certificate.getPublicKey()));
        }
        if (key != null) {
            String string2 = this.localIds.remove(string);
            if (string2 != null) {
                certificate = (Certificate)this.keyCerts.remove(string2);
            }
            if (certificate != null) {
                this.chainCerts.remove(new c(certificate.getPublicKey()));
            }
        }
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        if (string == null) {
            throw new IllegalArgumentException("alias cannot be null");
        }
        Certificate certificate = (Certificate)this.certs.get(string);
        if (certificate == null) {
            String string2 = this.localIds.get(string);
            certificate = string2 != null ? (Certificate)this.keyCerts.get(string2) : (Certificate)this.keyCerts.get(string);
        }
        return certificate;
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        String string;
        Certificate certificate2;
        Enumeration enumeration = this.certs.elements();
        Enumeration enumeration2 = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            certificate2 = (Certificate)enumeration.nextElement();
            string = (String)enumeration2.nextElement();
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        enumeration = this.keyCerts.elements();
        enumeration2 = this.keyCerts.keys();
        while (enumeration.hasMoreElements()) {
            certificate2 = (Certificate)enumeration.nextElement();
            string = (String)enumeration2.nextElement();
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getCertificateChain.");
        }
        if (!this.engineIsKeyEntry(string)) {
            return null;
        }
        Certificate certificate = this.engineGetCertificate(string);
        if (certificate != null) {
            Certificate[] certificateArray;
            Vector<Certificate> vector = new Vector<Certificate>();
            while (certificate != null) {
                AuthorityKeyIdentifier authorityKeyIdentifier;
                Object object;
                Principal principal;
                certificateArray = (Certificate[])certificate;
                Certificate certificate2 = null;
                byte[] byArray = certificateArray.getExtensionValue(Extension.authorityKeyIdentifier.getId());
                if (byArray != null) {
                    try {
                        principal = new ASN1InputStream(byArray);
                        object = ((ASN1OctetString)principal.readObject()).getOctets();
                        principal = new ASN1InputStream((byte[])object);
                        authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance((Object)principal.readObject());
                        if (authorityKeyIdentifier.getKeyIdentifier() != null) {
                            certificate2 = this.chainCerts.get(new c(authorityKeyIdentifier.getKeyIdentifier()));
                        }
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException.toString());
                    }
                }
                if (certificate2 == null && !((Object)(principal = certificateArray.getIssuerDN())).equals(object = certificateArray.getSubjectDN())) {
                    authorityKeyIdentifier = this.chainCerts.keys();
                    while (authorityKeyIdentifier.hasMoreElements()) {
                        X509Certificate x509Certificate = (X509Certificate)this.chainCerts.get(authorityKeyIdentifier.nextElement());
                        Principal principal2 = x509Certificate.getSubjectDN();
                        if (!((Object)principal2).equals(principal)) continue;
                        try {
                            certificateArray.verify(x509Certificate.getPublicKey());
                            certificate2 = x509Certificate;
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                if (vector.contains(certificate)) {
                    certificate = null;
                    continue;
                }
                vector.addElement(certificate);
                if (certificate2 != certificate) {
                    certificate = certificate2;
                    continue;
                }
                certificate = null;
            }
            certificateArray = new Certificate[vector.size()];
            for (int i2 = 0; i2 != certificateArray.length; ++i2) {
                certificateArray[i2] = (Certificate)vector.elementAt(i2);
            }
            return certificateArray;
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String string) {
        if (string == null) {
            throw new NullPointerException("alias == null");
        }
        if (this.keys.get(string) == null && this.certs.get(string) == null) {
            return null;
        }
        return new Date();
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (string == null) {
            throw new IllegalArgumentException("null alias passed to getKey.");
        }
        return (Key)this.keys.get(string);
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        return this.certs.get(string) != null && this.keys.get(string) == null;
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        return this.keys.get(string) != null;
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (this.keys.get(string) != null) {
            throw new KeyStoreException("There is a key entry with the name " + string + ".");
        }
        this.certs.put(string, certificate);
        this.chainCerts.put(new c(certificate.getPublicKey()), certificate);
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new RuntimeException("operation not supported");
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (!(key instanceof PrivateKey)) {
            throw new KeyStoreException("PKCS12 does not support non-PrivateKeys");
        }
        if (key instanceof PrivateKey && certificateArray == null) {
            throw new KeyStoreException("no certificate chain for private key");
        }
        if (this.keys.get(string) != null) {
            this.engineDeleteEntry(string);
        }
        this.keys.put(string, key);
        if (certificateArray != null) {
            this.certs.put(string, certificateArray[0]);
            for (int i2 = 0; i2 != certificateArray.length; ++i2) {
                this.chainCerts.put(new c(certificateArray[i2].getPublicKey()), certificateArray[i2]);
            }
        }
    }

    @Override
    public int engineSize() {
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Enumeration enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            hashtable.put(enumeration.nextElement(), "cert");
        }
        enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != null) continue;
            hashtable.put(string, "key");
        }
        return hashtable.size();
    }

    protected PrivateKey unwrapKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, char[] cArray, boolean bl2) throws IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        try {
            if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance((Object)algorithmIdentifier.getParameters());
                PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), this.validateIterationCount(pKCS12PBEParams.getIterations()));
                Cipher cipher = Cipher.getInstance(aSN1ObjectIdentifier.getId());
                PKCS12Key pKCS12Key = new PKCS12Key(cArray, bl2);
                cipher.init(4, (Key)pKCS12Key, pBEParameterSpec);
                return (PrivateKey)cipher.unwrap(byArray, "", 2);
            }
            if (aSN1ObjectIdentifier.equals((ASN1Primitive)PKCSObjectIdentifiers.id_PBES2)) {
                Cipher cipher = this.createCipher(4, cArray, algorithmIdentifier);
                return (PrivateKey)cipher.unwrap(byArray, "", 2);
            }
        }
        catch (Exception exception) {
            throw new IOException("exception unwrapping private key - " + exception.toString());
        }
        throw new IOException("exception unwrapping private key - cannot recognise: " + aSN1ObjectIdentifier);
    }

    protected byte[] cryptData(boolean bl2, AlgorithmIdentifier algorithmIdentifier, char[] cArray, boolean bl3, byte[] byArray) throws IOException {
        int n2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        int n3 = n2 = bl2 ? 1 : 2;
        if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
            PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance((Object)algorithmIdentifier.getParameters());
            try {
                PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
                SecretKey secretKey = this.getPBEKey(cArray);
                Cipher cipher = Cipher.getInstance(aSN1ObjectIdentifier.getId());
                cipher.init(n2, (Key)secretKey, pBEParameterSpec);
                return cipher.doFinal(byArray);
            }
            catch (Exception exception) {
                throw new IOException("exception decrypting data - " + exception.toString());
            }
        }
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)PKCSObjectIdentifiers.id_PBES2)) {
            try {
                Cipher cipher = this.createCipher(n2, cArray, algorithmIdentifier);
                return cipher.doFinal(byArray);
            }
            catch (Exception exception) {
                throw new IOException("exception decrypting data - " + exception.toString());
            }
        }
        throw new IOException("unknown PBE algorithm: " + aSN1ObjectIdentifier);
    }

    private SecretKey getPBEKey(char[] cArray) throws IOException {
        DDPBEKey dDPBEKey = null;
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            dDPBEKey = new DDPBEKey(pBEKeySpec, "PBE");
        }
        catch (Exception exception) {
            IOException iOException = new IOException("getSecretKey failed: " + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return dDPBEKey;
    }

    private Cipher createCipher(int n2, char[] cArray, AlgorithmIdentifier algorithmIdentifier) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchProviderException {
        PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance((Object)algorithmIdentifier.getParameters());
        PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance((Object)pBES2Parameters.getKeyDerivationFunc().getParameters());
        AlgorithmIdentifier algorithmIdentifier2 = AlgorithmIdentifier.getInstance((Object)pBES2Parameters.getEncryptionScheme());
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(pBES2Parameters.getKeyDerivationFunc().getAlgorithm().getId());
        SecretKey secretKey = pBKDF2Params.isDefaultPrf() ? secretKeyFactory.generateSecret(new PBEKeySpec(cArray, pBKDF2Params.getSalt(), this.validateIterationCount(pBKDF2Params.getIterationCount()), keySizeProvider.a(algorithmIdentifier2))) : secretKeyFactory.generateSecret((KeySpec)new PBKDF2KeySpec(cArray, pBKDF2Params.getSalt(), this.validateIterationCount(pBKDF2Params.getIterationCount()), keySizeProvider.a(algorithmIdentifier2), pBKDF2Params.getPrf()));
        Cipher cipher = Cipher.getInstance(pBES2Parameters.getEncryptionScheme().getAlgorithm().getId());
        ASN1Encodable aSN1Encodable = pBES2Parameters.getEncryptionScheme().getParameters();
        if (aSN1Encodable instanceof ASN1OctetString) {
            cipher.init(n2, (Key)secretKey, new IvParameterSpec(ASN1OctetString.getInstance((Object)aSN1Encodable).getOctets()));
        } else {
            GOST28147Parameters gOST28147Parameters = GOST28147Parameters.getInstance((Object)aSN1Encodable);
            cipher.init(n2, (Key)secretKey, (AlgorithmParameterSpec)new GOST28147ParameterSpec(gOST28147Parameters.getEncryptionParamSet(), gOST28147Parameters.getIV()));
        }
        return cipher;
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        PrivateKey privateKey;
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
        Object object5;
        Object object6;
        Object object7;
        SafeBag safeBag;
        MacData macData;
        if (inputStream == null) {
            return;
        }
        if (cArray == null) {
            throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(10);
        int n2 = bufferedInputStream.read();
        if (n2 != 48) {
            throw new IOException("stream does not represent a PKCS12 key store");
        }
        bufferedInputStream.reset();
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)bufferedInputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        Pfx pfx = Pfx.getInstance((Object)aSN1Sequence);
        ContentInfo contentInfo = pfx.getAuthSafe();
        Vector<Object> vector = new Vector<Object>();
        boolean bl2 = false;
        boolean bl3 = false;
        if (pfx.getMacData() != null) {
            macData = pfx.getMacData();
            safeBag = macData.getMac();
            this.macAlgorithm = safeBag.getAlgorithmId();
            byte[] byArray = macData.getSalt();
            this.itCount = this.validateIterationCount(macData.getIterationCount());
            object7 = ((ASN1OctetString)contentInfo.getContent()).getOctets();
            try {
                object6 = this.calculatePbeMac(this.macAlgorithm.getAlgorithm(), byArray, this.itCount, cArray, false, (byte[])object7);
                object5 = safeBag.getDigest();
                if (!Arrays.constantTimeAreEqual((byte[])object6, (byte[])object5)) {
                    if (cArray.length > 0) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    object6 = this.calculatePbeMac(this.macAlgorithm.getAlgorithm(), byArray, this.itCount, cArray, true, (byte[])object7);
                    if (!Arrays.constantTimeAreEqual((byte[])object6, (byte[])object5)) {
                        throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                    }
                    bl3 = true;
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("error constructing MAC: " + exception.toString());
            }
        }
        this.keys = new g();
        this.localIds = new Hashtable();
        if (contentInfo.getContentType().equals((ASN1Primitive)data)) {
            aSN1InputStream = new ASN1InputStream(((ASN1OctetString)contentInfo.getContent()).getOctets());
            macData = AuthenticatedSafe.getInstance((Object)aSN1InputStream.readObject());
            safeBag = macData.getContentInfo();
            for (int i2 = 0; i2 != ((ContentInfo[])safeBag).length; ++i2) {
                ASN1Encodable aSN1Encodable;
                ASN1Primitive aSN1Primitive;
                ASN1Set aSN1Set;
                Object object8;
                Object object9;
                if (safeBag[i2].getContentType().equals((ASN1Primitive)data)) {
                    object7 = new ASN1InputStream(((ASN1OctetString)safeBag[i2].getContent()).getOctets());
                    object6 = (ASN1Sequence)object7.readObject();
                    for (int i3 = 0; i3 != object6.size(); ++i3) {
                        SafeBag safeBag2 = SafeBag.getInstance((Object)object6.getObjectAt(i3));
                        if (safeBag2.getBagId().equals((ASN1Primitive)pkcs8ShroudedKeyBag)) {
                            encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance((Object)safeBag2.getBagValue());
                            privateKey = this.unwrapKey(encryptedPrivateKeyInfo.getEncryptionAlgorithm(), encryptedPrivateKeyInfo.getEncryptedData(), cArray, bl3);
                            object4 = (PKCS12BagAttributeCarrier)privateKey;
                            object3 = null;
                            object2 = null;
                            if (safeBag2.getBagAttributes() != null) {
                                object = safeBag2.getBagAttributes().getObjects();
                                while (object.hasMoreElements()) {
                                    object9 = (ASN1Sequence)object.nextElement();
                                    object8 = (ASN1ObjectIdentifier)object9.getObjectAt(0);
                                    aSN1Set = (ASN1Set)object9.getObjectAt(1);
                                    aSN1Primitive = null;
                                    if (aSN1Set.size() > 0) {
                                        aSN1Primitive = (ASN1Primitive)aSN1Set.getObjectAt(0);
                                        aSN1Encodable = object4.getBagAttribute(object8);
                                        if (aSN1Encodable != null) {
                                            if (!aSN1Encodable.toASN1Primitive().equals(aSN1Primitive)) {
                                                throw new IOException("attempt to add existing attribute with different value");
                                            }
                                        } else {
                                            object4.setBagAttribute(object8, (ASN1Encodable)aSN1Primitive);
                                        }
                                    }
                                    if (object8.equals((ASN1Primitive)pkcs_9_at_friendlyName)) {
                                        object3 = ((DERBMPString)aSN1Primitive).getString();
                                        this.keys.put((String)object3, privateKey);
                                        continue;
                                    }
                                    if (!object8.equals((ASN1Primitive)pkcs_9_at_localKeyId)) continue;
                                    object2 = (ASN1OctetString)aSN1Primitive;
                                }
                            }
                            if (object2 != null) {
                                object = new String(Hex.encode((byte[])object2.getOctets()));
                                if (object3 == null) {
                                    this.keys.put((String)object, privateKey);
                                    continue;
                                }
                                this.localIds.put((String)object3, (String)object);
                                continue;
                            }
                            bl2 = true;
                            this.keys.put("unmarked", privateKey);
                            continue;
                        }
                        if (!safeBag2.getBagId().equals((ASN1Primitive)certBag)) continue;
                        vector.addElement(safeBag2);
                    }
                    continue;
                }
                if (!safeBag[i2].getContentType().equals((ASN1Primitive)encryptedData)) continue;
                object7 = EncryptedData.getInstance((Object)safeBag[i2].getContent());
                object6 = this.cryptData(false, object7.getEncryptionAlgorithm(), cArray, bl3, object7.getContent().getOctets());
                object5 = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])object6);
                for (int i4 = 0; i4 != object5.size(); ++i4) {
                    ASN1Encodable aSN1Encodable2;
                    encryptedPrivateKeyInfo = SafeBag.getInstance((Object)object5.getObjectAt(i4));
                    if (encryptedPrivateKeyInfo.getBagId().equals((ASN1Primitive)certBag)) {
                        vector.addElement(encryptedPrivateKeyInfo);
                        continue;
                    }
                    if (encryptedPrivateKeyInfo.getBagId().equals((ASN1Primitive)pkcs8ShroudedKeyBag)) {
                        privateKey = EncryptedPrivateKeyInfo.getInstance((Object)encryptedPrivateKeyInfo.getBagValue());
                        object4 = this.unwrapKey(privateKey.getEncryptionAlgorithm(), privateKey.getEncryptedData(), cArray, bl3);
                        object3 = object4;
                        object2 = null;
                        object = null;
                        object9 = encryptedPrivateKeyInfo.getBagAttributes().getObjects();
                        while (object9.hasMoreElements()) {
                            object8 = (ASN1Sequence)object9.nextElement();
                            aSN1Set = (ASN1ObjectIdentifier)object8.getObjectAt(0);
                            aSN1Primitive = (ASN1Set)object8.getObjectAt(1);
                            aSN1Encodable = null;
                            if (aSN1Primitive.size() > 0) {
                                aSN1Encodable = (ASN1Primitive)aSN1Primitive.getObjectAt(0);
                                aSN1Encodable2 = object3.getBagAttribute((ASN1ObjectIdentifier)aSN1Set);
                                if (aSN1Encodable2 != null) {
                                    if (!aSN1Encodable2.toASN1Primitive().equals((ASN1Primitive)aSN1Encodable)) {
                                        throw new IOException("attempt to add existing attribute with different value");
                                    }
                                } else {
                                    object3.setBagAttribute((ASN1ObjectIdentifier)aSN1Set, aSN1Encodable);
                                }
                            }
                            if (aSN1Set.equals((ASN1Primitive)pkcs_9_at_friendlyName)) {
                                object2 = ((DERBMPString)aSN1Encodable).getString();
                                this.keys.put((String)object2, object4);
                                continue;
                            }
                            if (!aSN1Set.equals((ASN1Primitive)pkcs_9_at_localKeyId)) continue;
                            object = (ASN1OctetString)aSN1Encodable;
                        }
                        object8 = new String(Hex.encode((byte[])object.getOctets()));
                        if (object2 == null) {
                            this.keys.put((String)object8, object4);
                            continue;
                        }
                        this.localIds.put((String)object2, (String)object8);
                        continue;
                    }
                    if (!encryptedPrivateKeyInfo.getBagId().equals((ASN1Primitive)keyBag)) continue;
                    privateKey = PrivateKeyInfo.getInstance((Object)encryptedPrivateKeyInfo.getBagValue());
                    object4 = BouncyCastleProvider.getPrivateKey((PrivateKeyInfo)privateKey);
                    object3 = object4;
                    object2 = null;
                    object = null;
                    object9 = encryptedPrivateKeyInfo.getBagAttributes().getObjects();
                    while (object9.hasMoreElements()) {
                        object8 = ASN1Sequence.getInstance(object9.nextElement());
                        aSN1Set = ASN1ObjectIdentifier.getInstance((Object)object8.getObjectAt(0));
                        aSN1Primitive = ASN1Set.getInstance((Object)object8.getObjectAt(1));
                        aSN1Encodable = null;
                        if (aSN1Primitive.size() <= 0) continue;
                        aSN1Encodable = (ASN1Primitive)aSN1Primitive.getObjectAt(0);
                        aSN1Encodable2 = object3.getBagAttribute((ASN1ObjectIdentifier)aSN1Set);
                        if (aSN1Encodable2 != null) {
                            if (!aSN1Encodable2.toASN1Primitive().equals((ASN1Primitive)aSN1Encodable)) {
                                throw new IOException("attempt to add existing attribute with different value");
                            }
                        } else {
                            object3.setBagAttribute((ASN1ObjectIdentifier)aSN1Set, aSN1Encodable);
                        }
                        if (aSN1Set.equals((ASN1Primitive)pkcs_9_at_friendlyName)) {
                            object2 = ((DERBMPString)aSN1Encodable).getString();
                            this.keys.put((String)object2, object4);
                            continue;
                        }
                        if (!aSN1Set.equals((ASN1Primitive)pkcs_9_at_localKeyId)) continue;
                        object = (ASN1OctetString)aSN1Encodable;
                    }
                    object8 = new String(Hex.encode((byte[])object.getOctets()));
                    if (object2 == null) {
                        this.keys.put((String)object8, object4);
                        continue;
                    }
                    this.localIds.put((String)object2, (String)object8);
                }
            }
        }
        this.certs = new g();
        this.chainCerts = new Hashtable();
        this.keyCerts = new Hashtable();
        for (int i5 = 0; i5 != vector.size(); ++i5) {
            Object object10;
            safeBag = (SafeBag)vector.elementAt(i5);
            CertBag certBag = CertBag.getInstance((Object)safeBag.getBagValue());
            if (!certBag.getCertId().equals((ASN1Primitive)x509Certificate)) {
                throw new RuntimeException("Unsupported certificate type: " + certBag.getCertId());
            }
            try {
                object6 = new ByteArrayInputStream(((ASN1OctetString)certBag.getCertValue()).getOctets());
                object7 = this.certFact.generateCertificate((InputStream)object6);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
            object6 = null;
            object5 = null;
            if (safeBag.getBagAttributes() != null) {
                object10 = safeBag.getBagAttributes().getObjects();
                while (object10.hasMoreElements()) {
                    encryptedPrivateKeyInfo = ASN1Sequence.getInstance(object10.nextElement());
                    privateKey = ASN1ObjectIdentifier.getInstance((Object)encryptedPrivateKeyInfo.getObjectAt(0));
                    object4 = ASN1Set.getInstance((Object)encryptedPrivateKeyInfo.getObjectAt(1));
                    if (object4.size() <= 0) continue;
                    object3 = (ASN1Primitive)object4.getObjectAt(0);
                    object2 = null;
                    if (object7 instanceof PKCS12BagAttributeCarrier) {
                        object2 = (PKCS12BagAttributeCarrier)object7;
                        object = object2.getBagAttribute((ASN1ObjectIdentifier)privateKey);
                        if (object != null) {
                            if (!object.toASN1Primitive().equals(object3)) {
                                throw new IOException("attempt to add existing attribute with different value");
                            }
                        } else {
                            object2.setBagAttribute((ASN1ObjectIdentifier)privateKey, (ASN1Encodable)object3);
                        }
                    }
                    if (privateKey.equals((ASN1Primitive)pkcs_9_at_friendlyName)) {
                        object5 = ((DERBMPString)object3).getString();
                        continue;
                    }
                    if (!privateKey.equals((ASN1Primitive)pkcs_9_at_localKeyId)) continue;
                    object6 = (ASN1OctetString)object3;
                }
            }
            this.chainCerts.put(new c(((Certificate)object7).getPublicKey()), (Certificate)object7);
            if (bl2) {
                if (!this.keyCerts.isEmpty()) continue;
                object10 = new String(Hex.encode((byte[])this.createSubjectKeyId(((Certificate)object7).getPublicKey()).getKeyIdentifier()));
                this.keyCerts.put(object10, object7);
                this.keys.put((String)object10, this.keys.remove("unmarked"));
                continue;
            }
            if (object6 != null) {
                object10 = new String(Hex.encode((byte[])object6.getOctets()));
                this.keyCerts.put(object10, object7);
            }
            if (object5 != null) {
                this.certs.put((String)object5, object7);
                continue;
            }
            this.certs.put(Integer.toString(i5), object7);
        }
    }

    private int validateIterationCount(BigInteger bigInteger) {
        int n2 = bigInteger.intValue();
        if (n2 < 0) {
            throw new IllegalStateException("negative iteration count found");
        }
        BigInteger bigInteger2 = Properties.asBigInteger((String)PKCS12_MAX_IT_COUNT_PROPERTY);
        if (bigInteger2 != null && bigInteger2.intValue() < n2) {
            throw new IllegalStateException("iteration count " + n2 + " greater than " + bigInteger2.intValue());
        }
        return n2;
    }

    @Override
    public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    private Set getUsedCertificateSet() {
        Object object;
        String string;
        HashSet<Object> hashSet = new HashSet<Object>();
        Enumeration enumeration = this.keys.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.engineGetCertificateChain(string);
            for (int i2 = 0; i2 != ((Certificate[])object).length; ++i2) {
                hashSet.add(object[i2]);
            }
        }
        enumeration = this.certs.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.engineGetCertificate(string);
            hashSet.add(object);
        }
        return hashSet;
    }

    private byte[] calculatePbeMac(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray, int n2, char[] cArray, boolean bl2, byte[] byArray2) throws Exception {
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        BaseMac baseMac = (BaseMac)bouncyCastleProvider.getService("Mac", aSN1ObjectIdentifier.getId()).newInstance(null);
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray, n2);
        DDPKCS12KeyStoreProvider.baseMacinit().invoke((Object)baseMac, new PKCS12Key(cArray, bl2), pBEParameterSpec);
        DDPKCS12KeyStoreProvider.baseMacUpdate().invoke((Object)baseMac, byArray2, 0, byArray2.length);
        return (byte[])DDPKCS12KeyStoreProvider.baseMacDoFinal().invoke((Object)baseMac, new Object[0]);
    }

    private static Method baseMacUpdate() throws NoSuchMethodException {
        if (updateMethod == null) {
            updateMethod = BaseMac.class.getDeclaredMethod("engineUpdate", byte[].class, Integer.TYPE, Integer.TYPE);
            updateMethod.setAccessible(true);
        }
        return updateMethod;
    }

    private static Method baseMacDoFinal() throws NoSuchMethodException {
        if (doFinalMethod == null) {
            doFinalMethod = BaseMac.class.getDeclaredMethod("engineDoFinal", new Class[0]);
            doFinalMethod.setAccessible(true);
        }
        return doFinalMethod;
    }

    private static Method baseMacinit() throws NoSuchMethodException {
        if (initMethod == null) {
            initMethod = BaseMac.class.getDeclaredMethod("engineInit", Key.class, AlgorithmParameterSpec.class);
            initMethod.setAccessible(true);
        }
        return initMethod;
    }

    private static class f {
        private final Map KEY_SIZES;

        f() {
            HashMap<ASN1ObjectIdentifier, Integer> hashMap = new HashMap<ASN1ObjectIdentifier, Integer>();
            hashMap.put(new ASN1ObjectIdentifier("1.2.840.113533.7.66.10"), Integers.valueOf((int)128));
            hashMap.put(PKCSObjectIdentifiers.des_EDE3_CBC, Integers.valueOf((int)192));
            hashMap.put(NISTObjectIdentifiers.id_aes128_CBC, Integers.valueOf((int)128));
            hashMap.put(NISTObjectIdentifiers.id_aes192_CBC, Integers.valueOf((int)192));
            hashMap.put(NISTObjectIdentifiers.id_aes256_CBC, Integers.valueOf((int)256));
            hashMap.put(NTTObjectIdentifiers.id_camellia128_cbc, Integers.valueOf((int)128));
            hashMap.put(NTTObjectIdentifiers.id_camellia192_cbc, Integers.valueOf((int)192));
            hashMap.put(NTTObjectIdentifiers.id_camellia256_cbc, Integers.valueOf((int)256));
            hashMap.put(CryptoProObjectIdentifiers.gostR28147_gcfb, Integers.valueOf((int)256));
            this.KEY_SIZES = Collections.unmodifiableMap(hashMap);
        }

        public int a(AlgorithmIdentifier algorithmIdentifier) {
            Integer n2 = (Integer)this.KEY_SIZES.get(algorithmIdentifier.getAlgorithm());
            if (n2 != null) {
                return n2;
            }
            return -1;
        }
    }

    private static class g {
        private Hashtable orig = new Hashtable();
        private Hashtable keys = new Hashtable();

        private g() {
        }

        public void put(String string, Object object) {
            String string2 = string == null ? null : Strings.toLowerCase((String)string);
            String string3 = (String)this.keys.get(string2);
            if (string3 != null) {
                this.orig.remove(string3);
            }
            this.keys.put(string2, string);
            this.orig.put(string, object);
        }

        public Enumeration keys() {
            return this.orig.keys();
        }

        public Object remove(String string) {
            String string2 = (String)this.keys.remove(string == null ? null : Strings.toLowerCase((String)string));
            if (string2 == null) {
                return null;
            }
            return this.orig.remove(string2);
        }

        public Object get(String string) {
            String string2 = (String)this.keys.get(string == null ? null : Strings.toLowerCase((String)string));
            if (string2 == null) {
                return null;
            }
            return this.orig.get(string2);
        }

        public Enumeration elements() {
            return this.orig.elements();
        }
    }

    public static class e
    extends DDPKCS12KeyStoreProvider {
        public e() {
            super(null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    public static class d
    extends DDPKCS12KeyStoreProvider {
        public d() {
            super(null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd40BitRC2_CBC);
        }
    }

    public static class b
    extends DDPKCS12KeyStoreProvider {
        public b() {
            super((Provider)new BouncyCastleProvider(), pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    public static class a
    extends DDPKCS12KeyStoreProvider {
        public a() {
            super((Provider)new BouncyCastleProvider(), pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd40BitRC2_CBC);
        }
    }

    public static class h
    extends BaseBlockCipher {
        public h(BlockCipher blockCipher) {
            super(blockCipher);
        }
    }

    private class c {
        byte[] id;

        c(PublicKey publicKey) {
            this.id = DDPKCS12KeyStoreProvider.this.createSubjectKeyId(publicKey).getKeyIdentifier();
        }

        c(byte[] byArray) {
            this.id = byArray;
        }

        public int hashCode() {
            return Arrays.hashCode((byte[])this.id);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof c)) {
                return false;
            }
            c c2 = (c)object;
            return Arrays.areEqual((byte[])this.id, (byte[])c2.id);
        }
    }
}

