/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.PNameC;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.NameTable;

public class CharBasedPNameTable
extends NameTable {
    static final int MIN_HASH_SIZE = 16;
    protected static final float DEFAULT_FILL_FACTOR = 0.75f;
    protected PNameC[] _symbols;
    protected Bucket[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected boolean _dirty;

    public CharBasedPNameTable(int n2) {
        int n3;
        this._dirty = true;
        if (n2 < 1) {
            throw new IllegalArgumentException("Can not use negative/zero initial size: " + n2);
        }
        for (n3 = 16; n3 < n2; n3 += n3) {
        }
        n2 = n3;
        this._symbols = new PNameC[n2];
        this._buckets = new Bucket[n2 >> 1];
        this._indexMask = n2 - 1;
        this._size = 0;
        this._sizeThreshold = n2 * 3 + 3 >> 2;
    }

    CharBasedPNameTable(CharBasedPNameTable charBasedPNameTable) {
        this._symbols = charBasedPNameTable._symbols;
        this._buckets = charBasedPNameTable._buckets;
        this._size = charBasedPNameTable._size;
        this._sizeThreshold = charBasedPNameTable._sizeThreshold;
        this._indexMask = charBasedPNameTable._indexMask;
        this._dirty = false;
    }

    public synchronized void mergeFromChild(CharBasedPNameTable charBasedPNameTable) {
        if (charBasedPNameTable.size() <= this.size()) {
            return;
        }
        this._symbols = charBasedPNameTable._symbols;
        this._buckets = charBasedPNameTable._buckets;
        this._size = charBasedPNameTable._size;
        this._sizeThreshold = charBasedPNameTable._sizeThreshold;
        this._indexMask = charBasedPNameTable._indexMask;
        this._dirty = false;
        charBasedPNameTable._dirty = false;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean maybeDirty() {
        return this._dirty;
    }

    public PNameC findSymbol(char[] cArray, int n2, int n3, int n4) {
        int n5 = n4 & this._indexMask;
        PNameC pNameC = this._symbols[n5];
        if (pNameC != null) {
            if (pNameC.equalsPName(cArray, n2, n3, n4)) {
                return pNameC;
            }
            Bucket bucket = this._buckets[n5 >> 1];
            if (bucket != null && (pNameC = bucket.find(cArray, n2, n3, n4)) != null) {
                return pNameC;
            }
        }
        return null;
    }

    public PNameC addSymbol(char[] cArray, int n2, int n3, int n4) {
        boolean bl2;
        String string = new String(cArray, n2, n3).intern();
        PNameC pNameC = PNameC.construct(string, n4);
        int n5 = n4 & this._indexMask;
        if (null == this._symbols[n5]) {
            bl2 = true;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            n5 = n4 & this._indexMask;
            bl2 = null == this._symbols[n5];
        } else {
            bl2 = false;
        }
        if (!this._dirty) {
            this.copyArrays();
        }
        ++this._size;
        if (bl2) {
            this._symbols[n5] = pNameC;
        } else {
            int n6 = n5 >> 1;
            this._buckets[n6] = new Bucket(pNameC, this._buckets[n6]);
        }
        return pNameC;
    }

    private void copyArrays() {
        PNameC[] pNameCArray = this._symbols;
        int n2 = pNameCArray.length;
        this._symbols = new PNameC[n2];
        System.arraycopy(pNameCArray, 0, this._symbols, 0, n2);
        Bucket[] bucketArray = this._buckets;
        n2 = bucketArray.length;
        this._buckets = new Bucket[n2];
        System.arraycopy(bucketArray, 0, this._buckets, 0, n2);
        this._dirty = true;
    }

    private void rehash() {
        int n2;
        Object object;
        int n3;
        int n4 = this._symbols.length;
        int n5 = n4 + n4;
        PNameC[] pNameCArray = this._symbols;
        Bucket[] bucketArray = this._buckets;
        this._symbols = new PNameC[n5];
        this._buckets = new Bucket[n5 >> 1];
        this._indexMask = n5 - 1;
        this._sizeThreshold += this._sizeThreshold;
        int n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            object = pNameCArray[n3];
            if (object == null) continue;
            ++n6;
            int n7 = ((PNameC)object).getCustomHash() & this._indexMask;
            if (this._symbols[n7] == null) {
                this._symbols[n7] = object;
                continue;
            }
            n2 = n7 >> 1;
            this._buckets[n2] = new Bucket((PNameC)object, this._buckets[n2]);
        }
        n4 >>= 1;
        for (n3 = 0; n3 < n4; ++n3) {
            for (object = bucketArray[n3]; object != null; object = ((Bucket)object).getNext()) {
                ++n6;
                PNameC pNameC = ((Bucket)object).getSymbol();
                n2 = pNameC.getCustomHash() & this._indexMask;
                if (this._symbols[n2] == null) {
                    this._symbols[n2] = pNameC;
                    continue;
                }
                int n8 = n2 >> 1;
                this._buckets[n8] = new Bucket(pNameC, this._buckets[n8]);
            }
        }
        if (n6 != this._size) {
            throw new Error("Internal error on SymbolTable.rehash(): had " + this._size + " entries; now have " + n6 + ".");
        }
    }

    static final class Bucket {
        private final PNameC mSymbol;
        private final Bucket mNext;

        public Bucket(PNameC pNameC, Bucket bucket) {
            this.mSymbol = pNameC;
            this.mNext = bucket;
        }

        public PNameC getSymbol() {
            return this.mSymbol;
        }

        public Bucket getNext() {
            return this.mNext;
        }

        public PNameC find(char[] cArray, int n2, int n3, int n4) {
            Bucket bucket = this;
            do {
                PNameC pNameC;
                if (!(pNameC = bucket.mSymbol).equalsPName(cArray, n2, n3, n4)) continue;
                return pNameC;
            } while ((bucket = bucket.getNext()) != null);
            return null;
        }
    }
}

