/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.in.NsBinding;

public final class NsDeclaration {
    private final NsBinding mBinding;
    private final String mPreviousURI;
    private final NsDeclaration mPrevDeclaration;
    private final int mLevel;

    public NsDeclaration(NsBinding nsBinding, String string, NsDeclaration nsDeclaration, int n2) {
        this.mBinding = nsBinding;
        this.mPrevDeclaration = nsDeclaration;
        this.mLevel = n2;
        this.mPreviousURI = nsBinding.mURI;
        nsBinding.mURI = string;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public NsDeclaration getPrev() {
        return this.mPrevDeclaration;
    }

    public NsBinding getBinding() {
        return this.mBinding;
    }

    public String getPrefix() {
        return this.mBinding.mPrefix;
    }

    public String getCurrNsURI() {
        return this.mBinding.mURI;
    }

    public boolean hasPrefix(String string) {
        return string.equals(this.mBinding.mPrefix);
    }

    public boolean hasNsURI(String string) {
        return string.equals(this.mBinding.mURI);
    }

    public NsDeclaration unbind() {
        this.mBinding.mURI = this.mPreviousURI;
        return this.mPrevDeclaration;
    }

    public boolean alreadyDeclared(String string, int n2) {
        if (this.mLevel >= n2) {
            if (string == this.mBinding.mPrefix) {
                return true;
            }
            NsDeclaration nsDeclaration = this.mPrevDeclaration;
            while (nsDeclaration != null && nsDeclaration.mLevel >= n2) {
                if (string == nsDeclaration.mBinding.mPrefix) {
                    return true;
                }
                nsDeclaration = nsDeclaration.mPrevDeclaration;
            }
        }
        return false;
    }

    public int countDeclsOnLevel(int n2) {
        int n3 = 0;
        if (this.mLevel == n2) {
            ++n3;
            NsDeclaration nsDeclaration = this.mPrevDeclaration;
            while (nsDeclaration != null && nsDeclaration.mLevel == n2) {
                ++n3;
                nsDeclaration = nsDeclaration.mPrevDeclaration;
            }
        }
        return n3;
    }

    public String toString() {
        return "[NS-DECL, prefix = <" + this.mBinding.mPrefix + ">, current URI <" + this.mBinding.mURI + ">, level " + this.mLevel + ", prev URI <" + this.mPreviousURI + ">]";
    }
}

