/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.XmlCharTypes;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.XmlChars;

public final class OutputCharTypes
extends XmlCharTypes {
    static final int MAIN_TABLE_SIZE = 2048;
    public static final int CT_OUTPUT_MUST_QUOTE = 4;
    public static final int CT_OUTPUT_NAME_UNENCODABLE = 4;
    public static final int CT_OUTPUT_NAME_NONFIRST_MB2 = 5;
    public static final int CT_OUTPUT_NAME_ANY_MB2 = 6;
    private static XmlCharTypes sAsciiCharTypes = null;
    private static XmlCharTypes sLatin1CharTypes = null;
    private static final XmlCharTypes sUtf8CharTypes = new XmlCharTypes(2048);

    public static final XmlCharTypes getUtf8CharTypes() {
        return sUtf8CharTypes;
    }

    public static final XmlCharTypes getLatin1CharTypes() {
        if (sLatin1CharTypes == null) {
            sLatin1CharTypes = new XmlCharTypes(2048);
            OutputCharTypes.fillInLatin1Chars(OutputCharTypes.sLatin1CharTypes.TEXT_CHARS, OutputCharTypes.sLatin1CharTypes.ATTR_CHARS, OutputCharTypes.sLatin1CharTypes.NAME_CHARS, OutputCharTypes.sLatin1CharTypes.DTD_CHARS, OutputCharTypes.sLatin1CharTypes.OTHER_CHARS);
            OutputCharTypes.modifyForLatin1(OutputCharTypes.sLatin1CharTypes.TEXT_CHARS);
            OutputCharTypes.modifyForLatin1(OutputCharTypes.sLatin1CharTypes.ATTR_CHARS);
            OutputCharTypes.modifyForLatin1(OutputCharTypes.sLatin1CharTypes.DTD_CHARS);
            OutputCharTypes.modifyForLatin1(OutputCharTypes.sLatin1CharTypes.OTHER_CHARS);
            OutputCharTypes.modifyForAttrWrite(OutputCharTypes.sLatin1CharTypes.ATTR_CHARS);
        }
        return sLatin1CharTypes;
    }

    public static final XmlCharTypes getAsciiCharTypes() {
        if (sAsciiCharTypes == null) {
            sAsciiCharTypes = new XmlCharTypes(2048);
            OutputCharTypes.fillInLatin1Chars(OutputCharTypes.sAsciiCharTypes.TEXT_CHARS, OutputCharTypes.sAsciiCharTypes.ATTR_CHARS, OutputCharTypes.sAsciiCharTypes.NAME_CHARS, OutputCharTypes.sAsciiCharTypes.DTD_CHARS, OutputCharTypes.sAsciiCharTypes.OTHER_CHARS);
            OutputCharTypes.modifyForAscii(OutputCharTypes.sAsciiCharTypes.TEXT_CHARS);
            OutputCharTypes.modifyForAscii(OutputCharTypes.sAsciiCharTypes.ATTR_CHARS);
            OutputCharTypes.modifyForAscii(OutputCharTypes.sAsciiCharTypes.DTD_CHARS);
            OutputCharTypes.modifyForAscii(OutputCharTypes.sAsciiCharTypes.OTHER_CHARS);
            OutputCharTypes.modifyAsciiNames(OutputCharTypes.sAsciiCharTypes.NAME_CHARS);
            OutputCharTypes.modifyForAttrWrite(OutputCharTypes.sAsciiCharTypes.ATTR_CHARS);
        }
        return sAsciiCharTypes;
    }

    private static void modifyForLatin1(int[] nArray) {
        for (int i2 = 127; i2 <= 159; ++i2) {
            nArray[i2] = 4;
        }
        OutputCharTypes.requireQuotingAfter(nArray, 255);
    }

    private static void modifyLatin1Names(int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 256; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            if (n3 != 2 && n3 != 3) continue;
            nArray[i2] = 4;
        }
    }

    private static void modifyForUtf8(int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 128; i2 < n2; ++i2) {
            if (nArray[i2] != 0) continue;
            nArray[i2] = 5;
        }
    }

    private static void modifyUtf8Names(int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 128; i2 < n2; ++i2) {
            nArray[i2] = XmlChars.is10NameStartChar(i2) ? 6 : (XmlChars.is10NameChar(i2) ? 5 : 0);
        }
    }

    private static void modifyForAscii(int[] nArray) {
        OutputCharTypes.requireQuotingAfter(nArray, 127);
    }

    private static void modifyAsciiNames(int[] nArray) {
        OutputCharTypes.modifyLatin1Names(nArray);
        int n2 = nArray.length;
        for (int i2 = 128; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            if (n3 != 2 && n3 != 3) continue;
            nArray[i2] = 4;
        }
    }

    private static void modifyForAttrWrite(int[] nArray) {
        nArray[9] = 4;
    }

    private static void requireQuotingAfter(int[] nArray, int n2) {
        int n3 = nArray.length;
        for (int i2 = n2 + 1; i2 < n3; ++i2) {
            if (nArray[i2] != 0) continue;
            nArray[i2] = 4;
        }
    }

    static {
        OutputCharTypes.fillInLatin1Chars(OutputCharTypes.sUtf8CharTypes.TEXT_CHARS, OutputCharTypes.sUtf8CharTypes.ATTR_CHARS, OutputCharTypes.sUtf8CharTypes.NAME_CHARS, OutputCharTypes.sUtf8CharTypes.DTD_CHARS, OutputCharTypes.sUtf8CharTypes.OTHER_CHARS);
        OutputCharTypes.modifyForUtf8(OutputCharTypes.sUtf8CharTypes.TEXT_CHARS);
        OutputCharTypes.modifyForUtf8(OutputCharTypes.sUtf8CharTypes.ATTR_CHARS);
        OutputCharTypes.modifyForUtf8(OutputCharTypes.sUtf8CharTypes.DTD_CHARS);
        OutputCharTypes.modifyForUtf8(OutputCharTypes.sUtf8CharTypes.OTHER_CHARS);
        OutputCharTypes.modifyUtf8Names(OutputCharTypes.sUtf8CharTypes.NAME_CHARS);
        OutputCharTypes.modifyForAttrWrite(OutputCharTypes.sUtf8CharTypes.ATTR_CHARS);
    }
}

