/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.NsBinder;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WName;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.EmptyIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

final class OutputElement {
    static final byte BYTE_LT = 60;
    static final byte BYTE_GT = 62;
    static final byte BYTE_SLASH = 47;
    OutputElement _parent;
    WName _name;
    String _uri;
    String _defaultNsURI = "";
    NsBinder _nsBinder = null;

    private OutputElement() {
        this._parent = null;
        this._name = null;
        this._uri = null;
        this._nsBinder = null;
        this._defaultNsURI = "";
    }

    private OutputElement(OutputElement outputElement, WName wName, String string, NsBinder nsBinder) {
        this._parent = outputElement;
        this._name = wName;
        this._uri = string;
        this._nsBinder = nsBinder;
        this._defaultNsURI = outputElement._defaultNsURI;
    }

    protected static OutputElement createRoot() {
        return new OutputElement();
    }

    protected OutputElement createChild(WName wName) {
        return new OutputElement(this, wName, this._defaultNsURI, this._nsBinder);
    }

    protected OutputElement createChild(WName wName, String string) {
        return new OutputElement(this, wName, string, this._nsBinder);
    }

    protected OutputElement reuseAsChild(OutputElement outputElement, WName wName) {
        OutputElement outputElement2 = this._parent;
        this.relink(outputElement, wName, this._defaultNsURI);
        return outputElement2;
    }

    protected OutputElement reuseAsChild(OutputElement outputElement, WName wName, String string) {
        OutputElement outputElement2 = this._parent;
        this.relink(outputElement, wName, string);
        return outputElement2;
    }

    public void relink(OutputElement outputElement) {
        this._parent = outputElement;
        this._nsBinder = outputElement._nsBinder;
        this._defaultNsURI = outputElement._defaultNsURI;
    }

    private void relink(OutputElement outputElement, WName wName, String string) {
        this._parent = outputElement;
        this._name = wName;
        this._uri = string;
        this._nsBinder = outputElement._nsBinder;
        this._defaultNsURI = outputElement._defaultNsURI;
    }

    protected void addToPool(OutputElement outputElement) {
        this._parent = outputElement;
    }

    public OutputElement getParent() {
        return this._parent;
    }

    public boolean isRoot() {
        return this._parent == null;
    }

    public WName getName() {
        return this._name;
    }

    public String getLocalName() {
        return this._name.getLocalName();
    }

    public String getNonNullPrefix() {
        String string = this._name.getPrefix();
        return string == null ? "" : null;
    }

    public boolean hasPrefix() {
        return this._name.hasPrefix();
    }

    public String getNameDesc() {
        return this._name.toString();
    }

    public String getNamespaceURI() {
        return this._uri;
    }

    public String getNonNullNamespaceURI() {
        return this._uri == null ? "" : this._uri;
    }

    public String getDefaultNsURI() {
        return this._defaultNsURI;
    }

    public boolean hasEmptyDefaultNs() {
        return this._defaultNsURI == null || this._defaultNsURI.length() == 0;
    }

    public QName getQName() {
        return new QName(this._uri, this._name.getLocalName(), this._name.getPrefix());
    }

    public void setDefaultNsURI(String string) {
        this._defaultNsURI = string;
    }

    public String generatePrefix(NamespaceContext namespaceContext, String string, int[] nArray) {
        if (this._nsBinder == null) {
            this._nsBinder = NsBinder.createEmpty();
        }
        return this._nsBinder.generatePrefix(string, namespaceContext, nArray);
    }

    public void addPrefix(String string, String string2) {
        if (this._nsBinder == null) {
            this._nsBinder = NsBinder.createEmpty();
        } else if (this._parent != null && this._parent._nsBinder == this._nsBinder) {
            this._nsBinder = this._nsBinder.createChild();
        }
        this._nsBinder.addMapping(string, string2);
    }

    public String getNamespaceURI(String string) {
        String string2;
        if (string.length() == 0) {
            return this._defaultNsURI;
        }
        if (this._nsBinder != null && (string2 = this._nsBinder.findUriByPrefix(string)) != null) {
            return string2;
        }
        return null;
    }

    public String getPrefix(String string) {
        String string2;
        if (this._defaultNsURI.equals(string)) {
            return "";
        }
        if (this._nsBinder != null && (string2 = this._nsBinder.findPrefixByUri(string)) != null) {
            return string2;
        }
        return null;
    }

    public Iterator<String> getPrefixes(String string, NamespaceContext namespaceContext) {
        List<String> list = null;
        if (this._defaultNsURI.equals(string)) {
            list = new ArrayList<String>();
            list.add("");
        }
        if (this._nsBinder != null) {
            list = this._nsBinder.getPrefixesBoundToUri(string, list);
        }
        if (namespaceContext != null) {
            Iterator<String> iterator = namespaceContext.getPrefixes(string);
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                if (string2.length() == 0) continue;
                if (list == null) {
                    list = new ArrayList();
                } else if (list.contains(string2)) continue;
                list.add(string2);
            }
        }
        if (list == null) {
            return EmptyIterator.getInstance();
        }
        return list.iterator();
    }

    public String getExplicitPrefix(String string, NamespaceContext namespaceContext) {
        String string2;
        if (this._nsBinder != null && (string2 = this._nsBinder.findPrefixByUri(string)) != null) {
            return string2;
        }
        if (namespaceContext != null && (string2 = namespaceContext.getPrefix(string)) != null && string2.length() > 0) {
            return string2;
        }
        return null;
    }

    public PrefixState checkPrefixValidity(String string, String string2, NamespaceContext namespaceContext) {
        String string3;
        if (string.equals("xml")) {
            return string2.equals("http://www.w3.org/XML/1998/namespace") ? PrefixState.OK : PrefixState.MISBOUND;
        }
        String string4 = string3 = this._nsBinder == null ? null : this._nsBinder.findUriByPrefix(string);
        if (string3 == null && namespaceContext != null) {
            string3 = namespaceContext.getNamespaceURI(string);
        }
        if (string3 == null) {
            return PrefixState.UNBOUND;
        }
        return string3 == string2 || string3.equals(string2) ? PrefixState.OK : PrefixState.MISBOUND;
    }

    public boolean isPrefixBoundTo(String string, String string2, NamespaceContext namespaceContext) {
        String string3;
        if (string == null || string.length() == 0) {
            return this._defaultNsURI.equals(string2);
        }
        if ("xml".equals(string)) {
            return string2.equals("http://www.w3.org/XML/1998/namespace");
        }
        String string4 = string3 = this._nsBinder == null ? null : this._nsBinder.findUriByPrefix(string);
        if (string3 == null && namespaceContext != null) {
            string3 = namespaceContext.getNamespaceURI(string);
        }
        return string3 != null && (string3 == string2 || string3.equals(string2));
    }

    public boolean isPrefixUnbound(String string, NamespaceContext namespaceContext) {
        String string2;
        String string3 = string2 = this._nsBinder == null ? null : this._nsBinder.findUriByPrefix(string);
        if (string2 != null && string2.length() != 0) {
            return false;
        }
        if (string.equals("xml")) {
            return false;
        }
        return namespaceContext == null || (string2 = namespaceContext.getNamespaceURI(string)) == null || string2.length() == 0;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public static enum PrefixState {
        UNBOUND,
        OK,
        MISBOUND;

    }
}

