/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out;

import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.impl.ErrorConsts;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.impl.IoStreamException;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WName;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WNameFactory;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.out.WriterConfig;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.CharsetNames;
import com.ibm.cognos.externals.com.fasterxml.aalto_1_2_2.util.XmlChars;
import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.ri.typed.AsciiValueEncoder;
import java.io.IOException;
import java.text.MessageFormat;
import javax.xml.stream.XMLStreamException;

public abstract class XmlWriter
extends WNameFactory {
    protected static final int SURR1_FIRST = 55296;
    protected static final int SURR1_LAST = 56319;
    protected static final int SURR2_FIRST = 56320;
    protected static final int SURR2_LAST = 57343;
    protected static final int MIN_ARRAYCOPY = 12;
    protected static final int ATTR_MIN_ARRAYCOPY = 12;
    protected static final int DEFAULT_COPYBUFFER_LEN = 512;
    protected final WriterConfig _config;
    protected char[] _copyBuffer;
    protected final int _copyBufferLen;
    protected boolean _xml11 = false;
    protected final boolean _cfgNsAware;
    protected int _locPastChars = 0;
    protected int _locRowNr = 1;
    protected int _locRowStartOffset = 0;
    protected final boolean _checkContent;
    protected final boolean _checkNames;

    protected XmlWriter(WriterConfig writerConfig) {
        this._config = writerConfig;
        this._copyBuffer = writerConfig.allocMediumCBuffer(512);
        this._copyBufferLen = this._copyBuffer.length;
        this._cfgNsAware = writerConfig.isNamespaceAware();
        this._checkContent = writerConfig.willCheckContent();
        this._checkNames = writerConfig.willCheckNames();
    }

    @Override
    public abstract WName constructName(String var1) throws XMLStreamException;

    @Override
    public abstract WName constructName(String var1, String var2) throws XMLStreamException;

    public void enableXml11() {
        this._xml11 = true;
    }

    protected abstract int getOutputPtr();

    public abstract int getHighestEncodable();

    public final void close(boolean bl2) throws IOException {
        this.flush();
        this._releaseBuffers();
        this._closeTarget(bl2 || this._config.willAutoCloseOutput());
    }

    public void _releaseBuffers() {
        char[] cArray = this._copyBuffer;
        if (cArray != null) {
            this._copyBuffer = null;
            this._config.freeMediumCBuffer(cArray);
        }
    }

    public abstract void _closeTarget(boolean var1) throws IOException;

    public abstract void flush() throws IOException;

    public abstract int writeCData(String var1) throws IOException, XMLStreamException;

    public abstract int writeCData(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    public abstract void writeCharacters(String var1) throws IOException, XMLStreamException;

    public abstract void writeCharacters(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    public abstract void writeSpace(String var1) throws IOException, XMLStreamException;

    public abstract void writeSpace(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    public abstract int writeComment(String var1) throws IOException, XMLStreamException;

    public abstract void writeDTD(String var1) throws IOException, XMLStreamException;

    public abstract void writeDTD(WName var1, String var2, String var3, String var4) throws IOException, XMLStreamException;

    public abstract void writeEntityReference(WName var1) throws IOException, XMLStreamException;

    public abstract int writePI(WName var1, String var2) throws IOException, XMLStreamException;

    public abstract void writeRaw(String var1, int var2, int var3) throws IOException, XMLStreamException;

    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    public abstract void writeXmlDeclaration(String var1, String var2, String var3) throws IOException, XMLStreamException;

    public abstract void writeStartTagStart(WName var1) throws IOException, XMLStreamException;

    public abstract void writeStartTagEnd() throws IOException, XMLStreamException;

    public abstract void writeStartTagEmptyEnd() throws IOException, XMLStreamException;

    public abstract void writeEndTag(WName var1) throws IOException, XMLStreamException;

    public abstract void writeAttribute(WName var1, String var2) throws IOException, XMLStreamException;

    public abstract void writeAttribute(WName var1, char[] var2, int var3, int var4) throws IOException, XMLStreamException;

    public abstract void writeTypedValue(AsciiValueEncoder var1) throws IOException, XMLStreamException;

    public abstract void writeAttribute(WName var1, AsciiValueEncoder var2) throws IOException, XMLStreamException;

    public int getRow() {
        return this._locRowNr;
    }

    public int getColumn() {
        return this.getOutputPtr() - this._locRowStartOffset + 1;
    }

    public int getAbsOffset() {
        return this._locPastChars + this.getOutputPtr();
    }

    public static final int guessEncodingBitSize(WriterConfig writerConfig) {
        String string = writerConfig.getPreferredEncoding();
        if (string == null || string.length() == 0) {
            return 16;
        }
        if ((string = CharsetNames.normalize(string)) == "UTF-8") {
            return 16;
        }
        if (string == "ISO-8859-1") {
            return 8;
        }
        if (string == "US-ASCII") {
            return 7;
        }
        if (string == "UTF-16" || string == "UTF-16BE" || string == "UTF-16LE" || string == "UTF-32BE" || string == "UTF-32LE") {
            return 16;
        }
        return 8;
    }

    protected void reportNwfName(String string) throws XMLStreamException {
        this.throwOutputError(string);
    }

    protected void reportNwfName(String string, Object object) throws XMLStreamException {
        this.throwOutputError(string, object);
    }

    protected void reportNwfContent(String string) throws XMLStreamException {
        this.throwOutputError(string);
    }

    protected void reportNwfContent(String string, Object object, Object object2) throws XMLStreamException {
        String string2 = MessageFormat.format(string, object, object2);
        this.reportNwfContent(string2);
    }

    protected void reportFailedEscaping(String string, int n2) throws XMLStreamException {
        if (n2 == 65534 || n2 == 65535 || n2 >= 55296 && n2 <= 57343) {
            this.reportInvalidChar(n2);
        }
        if (!(n2 >= 32 || n2 != 0 && this._config.isXml11())) {
            this.reportInvalidChar(n2);
        }
        String string2 = MessageFormat.format(ErrorConsts.WERR_NO_ESCAPING, string, n2);
        this.reportNwfContent(string2);
    }

    protected void reportInvalidEmptyName() throws XMLStreamException {
        this.reportNwfContent("Empty String is not a valid name (local name, prefix or processing instruction target)");
    }

    protected void reportInvalidChar(int n2) throws XMLStreamException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
        if (n2 == 0) {
            this.reportNwfContent("Invalid null character in text to output");
        }
        if (n2 < 32 || n2 >= 127 && n2 <= 159) {
            String string = "Invalid white space character (0x" + Integer.toHexString(n2) + ") in text to output";
            if (this._xml11) {
                string = string + " (can only be output using character entity)";
            }
            this.reportNwfContent(string);
        }
        if (n2 > 0x10FFFF) {
            this.reportNwfContent("Illegal unicode character point (0x" + Integer.toHexString(n2) + ") to output; max is 0x10FFFF as per RFC 3629");
        }
        if (n2 >= 55296 && n2 <= 57343) {
            this.reportNwfContent("Illegal surrogate pair -- can only be output via character entities (for current encoding), which are not allowed in this content");
        }
        this.reportNwfContent("Invalid XML character " + XmlChars.getCharDesc(n2) + " in text to output");
    }

    protected void throwOutputError(String string) throws XMLStreamException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
        throw new XMLStreamException(string);
    }

    protected void throwOutputError(String string, Object object) throws XMLStreamException {
        String string2 = MessageFormat.format(string, object);
        this.throwOutputError(string2);
    }
}

