/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonFactory;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonGenerator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.SerializableString;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.TSFBuilder;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.io.CharacterEscapes;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.io.SerializedString;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.json.JsonReadFeature;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.json.JsonWriteFeature;

public class JsonFactoryBuilder
extends TSFBuilder<JsonFactory, JsonFactoryBuilder> {
    protected CharacterEscapes _characterEscapes;
    protected SerializableString _rootValueSeparator;
    protected int _maximumNonEscapedChar;
    protected char _quoteChar = (char)34;

    public JsonFactoryBuilder() {
        this._rootValueSeparator = JsonFactory.DEFAULT_ROOT_VALUE_SEPARATOR;
        this._maximumNonEscapedChar = 0;
    }

    public JsonFactoryBuilder(JsonFactory jsonFactory) {
        super(jsonFactory);
        this._characterEscapes = jsonFactory.getCharacterEscapes();
        this._rootValueSeparator = jsonFactory._rootValueSeparator;
        this._maximumNonEscapedChar = jsonFactory._maximumNonEscapedChar;
    }

    @Override
    public JsonFactoryBuilder enable(JsonReadFeature jsonReadFeature) {
        this._legacyEnable(jsonReadFeature.mappedFeature());
        return this;
    }

    @Override
    public JsonFactoryBuilder enable(JsonReadFeature jsonReadFeature, JsonReadFeature ... jsonReadFeatureArray) {
        this._legacyEnable(jsonReadFeature.mappedFeature());
        this.enable(jsonReadFeature);
        for (JsonReadFeature jsonReadFeature2 : jsonReadFeatureArray) {
            this._legacyEnable(jsonReadFeature2.mappedFeature());
        }
        return this;
    }

    @Override
    public JsonFactoryBuilder disable(JsonReadFeature jsonReadFeature) {
        this._legacyDisable(jsonReadFeature.mappedFeature());
        return this;
    }

    @Override
    public JsonFactoryBuilder disable(JsonReadFeature jsonReadFeature, JsonReadFeature ... jsonReadFeatureArray) {
        this._legacyDisable(jsonReadFeature.mappedFeature());
        for (JsonReadFeature jsonReadFeature2 : jsonReadFeatureArray) {
            this._legacyEnable(jsonReadFeature2.mappedFeature());
        }
        return this;
    }

    @Override
    public JsonFactoryBuilder configure(JsonReadFeature jsonReadFeature, boolean bl2) {
        return bl2 ? this.enable(jsonReadFeature) : this.disable(jsonReadFeature);
    }

    @Override
    public JsonFactoryBuilder enable(JsonWriteFeature jsonWriteFeature) {
        JsonGenerator.Feature feature = jsonWriteFeature.mappedFeature();
        if (feature != null) {
            this._legacyEnable(feature);
        }
        return this;
    }

    @Override
    public JsonFactoryBuilder enable(JsonWriteFeature jsonWriteFeature, JsonWriteFeature ... jsonWriteFeatureArray) {
        this._legacyEnable(jsonWriteFeature.mappedFeature());
        for (JsonWriteFeature jsonWriteFeature2 : jsonWriteFeatureArray) {
            this._legacyEnable(jsonWriteFeature2.mappedFeature());
        }
        return this;
    }

    @Override
    public JsonFactoryBuilder disable(JsonWriteFeature jsonWriteFeature) {
        this._legacyDisable(jsonWriteFeature.mappedFeature());
        return this;
    }

    @Override
    public JsonFactoryBuilder disable(JsonWriteFeature jsonWriteFeature, JsonWriteFeature ... jsonWriteFeatureArray) {
        this._legacyDisable(jsonWriteFeature.mappedFeature());
        for (JsonWriteFeature jsonWriteFeature2 : jsonWriteFeatureArray) {
            this._legacyDisable(jsonWriteFeature2.mappedFeature());
        }
        return this;
    }

    @Override
    public JsonFactoryBuilder configure(JsonWriteFeature jsonWriteFeature, boolean bl2) {
        return bl2 ? this.enable(jsonWriteFeature) : this.disable(jsonWriteFeature);
    }

    public JsonFactoryBuilder characterEscapes(CharacterEscapes characterEscapes) {
        this._characterEscapes = characterEscapes;
        return this;
    }

    public JsonFactoryBuilder rootValueSeparator(String string) {
        this._rootValueSeparator = string == null ? null : new SerializedString(string);
        return this;
    }

    public JsonFactoryBuilder rootValueSeparator(SerializableString serializableString) {
        this._rootValueSeparator = serializableString;
        return this;
    }

    public JsonFactoryBuilder highestNonEscapedChar(int n2) {
        this._maximumNonEscapedChar = n2 <= 0 ? 0 : Math.max(127, n2);
        return this;
    }

    public JsonFactoryBuilder quoteChar(char c2) {
        if (c2 > '\u007f') {
            throw new IllegalArgumentException("Can only use Unicode characters up to 0x7F as quote characters");
        }
        this._quoteChar = c2;
        return this;
    }

    public CharacterEscapes characterEscapes() {
        return this._characterEscapes;
    }

    public SerializableString rootValueSeparator() {
        return this._rootValueSeparator;
    }

    public int highestNonEscapedChar() {
        return this._maximumNonEscapedChar;
    }

    public char quoteChar() {
        return this._quoteChar;
    }

    @Override
    public JsonFactory build() {
        return new JsonFactory(this);
    }
}

