/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonParser;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonToken;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DeserializationContext;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonMappingException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.deser.std.StdScalarDeserializer;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.LogicalType;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class AtomicBooleanDeserializer
extends StdScalarDeserializer<AtomicBoolean> {
    private static final long serialVersionUID = 1L;

    public AtomicBooleanDeserializer() {
        super(AtomicBoolean.class);
    }

    @Override
    public AtomicBoolean deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return new AtomicBoolean(true);
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return new AtomicBoolean(false);
        }
        Boolean bl2 = this._parseBoolean(jsonParser, deserializationContext, AtomicBoolean.class);
        return bl2 == null ? null : new AtomicBoolean(bl2);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Boolean;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
        return new AtomicBoolean(false);
    }
}

