/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.node;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.Base64Variant;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonLocation;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonParseException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonParser;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonStreamContext;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonToken;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.ObjectCodec;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.StreamReadCapability;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.Version;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.base.ParserMinimalBase;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.util.JacksonFeatureSet;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JsonNode;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.cfg.PackageVersion;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.node.BinaryNode;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.node.NodeCursor;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.node.NumericNode;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.node.POJONode;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.node.TextNode;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class TreeTraversingParser
extends ParserMinimalBase {
    protected ObjectCodec _objectCodec;
    protected NodeCursor _nodeCursor;
    protected boolean _closed;

    public TreeTraversingParser(JsonNode jsonNode) {
        this(jsonNode, null);
    }

    public TreeTraversingParser(JsonNode jsonNode, ObjectCodec objectCodec) {
        super(0);
        this._objectCodec = objectCodec;
        this._nodeCursor = new NodeCursor.RootCursor(jsonNode, null);
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return DEFAULT_READ_CAPABILITIES;
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._nodeCursor = null;
            this._currToken = null;
        }
    }

    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        this._currToken = this._nodeCursor.nextToken();
        if (this._currToken == null) {
            this._closed = true;
            return null;
        }
        switch (this._currToken) {
            case START_OBJECT: {
                this._nodeCursor = this._nodeCursor.startObject();
                break;
            }
            case START_ARRAY: {
                this._nodeCursor = this._nodeCursor.startArray();
                break;
            }
            case END_OBJECT: 
            case END_ARRAY: {
                this._nodeCursor = this._nodeCursor.getParent();
            }
        }
        return this._currToken;
    }

    @Override
    public JsonParser skipChildren() throws IOException {
        if (this._currToken == JsonToken.START_OBJECT) {
            this._nodeCursor = this._nodeCursor.getParent();
            this._currToken = JsonToken.END_OBJECT;
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this._nodeCursor = this._nodeCursor.getParent();
            this._currToken = JsonToken.END_ARRAY;
        }
        return this;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public String getCurrentName() {
        NodeCursor nodeCursor = this._nodeCursor;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            nodeCursor = nodeCursor.getParent();
        }
        return nodeCursor == null ? null : nodeCursor.getCurrentName();
    }

    @Override
    public void overrideCurrentName(String string) {
        NodeCursor nodeCursor = this._nodeCursor;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            nodeCursor = nodeCursor.getParent();
        }
        if (nodeCursor != null) {
            nodeCursor.overrideCurrentName(string);
        }
    }

    @Override
    public JsonStreamContext getParsingContext() {
        return this._nodeCursor;
    }

    @Override
    public JsonLocation getTokenLocation() {
        return JsonLocation.NA;
    }

    @Override
    public JsonLocation getCurrentLocation() {
        return JsonLocation.NA;
    }

    @Override
    public String getText() {
        if (this._closed) {
            return null;
        }
        switch (this._currToken) {
            case FIELD_NAME: {
                return this._nodeCursor.getCurrentName();
            }
            case VALUE_STRING: {
                return this.currentNode().textValue();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return String.valueOf(this.currentNode().numberValue());
            }
            case VALUE_EMBEDDED_OBJECT: {
                JsonNode jsonNode = this.currentNode();
                if (jsonNode == null || !jsonNode.isBinary()) break;
                return jsonNode.asText();
            }
        }
        return this._currToken == null ? null : this._currToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException, JsonParseException {
        return this.getText().toCharArray();
    }

    @Override
    public int getTextLength() throws IOException, JsonParseException {
        return this.getText().length();
    }

    @Override
    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException {
        JsonNode jsonNode = this.currentNumericNode();
        return jsonNode == null ? null : jsonNode.numberType();
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        return this.currentNumericNode().bigIntegerValue();
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        return this.currentNumericNode().decimalValue();
    }

    @Override
    public double getDoubleValue() throws IOException {
        return this.currentNumericNode().doubleValue();
    }

    @Override
    public float getFloatValue() throws IOException {
        return (float)this.currentNumericNode().doubleValue();
    }

    @Override
    public int getIntValue() throws IOException {
        NumericNode numericNode = (NumericNode)this.currentNumericNode();
        if (!numericNode.canConvertToInt()) {
            this.reportOverflowInt();
        }
        return numericNode.intValue();
    }

    @Override
    public long getLongValue() throws IOException {
        NumericNode numericNode = (NumericNode)this.currentNumericNode();
        if (!numericNode.canConvertToLong()) {
            this.reportOverflowLong();
        }
        return numericNode.longValue();
    }

    @Override
    public Number getNumberValue() throws IOException {
        return this.currentNumericNode().numberValue();
    }

    @Override
    public Object getEmbeddedObject() {
        JsonNode jsonNode;
        if (!this._closed && (jsonNode = this.currentNode()) != null) {
            if (jsonNode.isPojo()) {
                return ((POJONode)jsonNode).getPojo();
            }
            if (jsonNode.isBinary()) {
                return ((BinaryNode)jsonNode).binaryValue();
            }
        }
        return null;
    }

    @Override
    public boolean isNaN() {
        JsonNode jsonNode;
        if (!this._closed && (jsonNode = this.currentNode()) instanceof NumericNode) {
            return ((NumericNode)jsonNode).isNaN();
        }
        return false;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        JsonNode jsonNode = this.currentNode();
        if (jsonNode != null) {
            if (jsonNode instanceof TextNode) {
                return ((TextNode)jsonNode).getBinaryValue(base64Variant);
            }
            return jsonNode.binaryValue();
        }
        return null;
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException, JsonParseException {
        byte[] byArray = this.getBinaryValue(base64Variant);
        if (byArray != null) {
            outputStream.write(byArray, 0, byArray.length);
            return byArray.length;
        }
        return 0;
    }

    protected JsonNode currentNode() {
        if (this._closed || this._nodeCursor == null) {
            return null;
        }
        return this._nodeCursor.currentNode();
    }

    protected JsonNode currentNumericNode() throws JsonParseException {
        JsonNode jsonNode = this.currentNode();
        if (jsonNode == null || !jsonNode.isNumber()) {
            JsonToken jsonToken = jsonNode == null ? null : jsonNode.asToken();
            throw this._constructError("Current token (" + (Object)((Object)jsonToken) + ") not numeric, cannot use numeric value accessors");
        }
        return jsonNode;
    }

    @Override
    protected void _handleEOF() throws JsonParseException {
        this._throwInternal();
    }
}

