/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JavaType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.TypeBindings;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.TypeFactory;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TypeParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final TypeFactory _factory;

    public TypeParser(TypeFactory typeFactory) {
        this._factory = typeFactory;
    }

    public TypeParser withFactory(TypeFactory typeFactory) {
        return typeFactory == this._factory ? this : new TypeParser(typeFactory);
    }

    public JavaType parse(String string) throws IllegalArgumentException {
        MyTokenizer myTokenizer = new MyTokenizer(string.trim());
        JavaType javaType = this.parseType(myTokenizer);
        if (myTokenizer.hasMoreTokens()) {
            throw this._problem(myTokenizer, "Unexpected tokens after complete type");
        }
        return javaType;
    }

    protected JavaType parseType(MyTokenizer myTokenizer) throws IllegalArgumentException {
        if (!myTokenizer.hasMoreTokens()) {
            throw this._problem(myTokenizer, "Unexpected end-of-string");
        }
        Class<?> clazz = this.findClass(myTokenizer.nextToken(), myTokenizer);
        if (myTokenizer.hasMoreTokens()) {
            String string = myTokenizer.nextToken();
            if ("<".equals(string)) {
                List<JavaType> list = this.parseTypes(myTokenizer);
                TypeBindings typeBindings = TypeBindings.create(clazz, list);
                return this._factory._fromClass(null, clazz, typeBindings);
            }
            myTokenizer.pushBack(string);
        }
        return this._factory._fromClass(null, clazz, TypeBindings.emptyBindings());
    }

    protected List<JavaType> parseTypes(MyTokenizer myTokenizer) throws IllegalArgumentException {
        ArrayList<JavaType> arrayList = new ArrayList<JavaType>();
        while (myTokenizer.hasMoreTokens()) {
            arrayList.add(this.parseType(myTokenizer));
            if (!myTokenizer.hasMoreTokens()) break;
            String string = myTokenizer.nextToken();
            if (">".equals(string)) {
                return arrayList;
            }
            if (",".equals(string)) continue;
            throw this._problem(myTokenizer, "Unexpected token '" + string + "', expected ',' or '>')");
        }
        throw this._problem(myTokenizer, "Unexpected end-of-string");
    }

    protected Class<?> findClass(String string, MyTokenizer myTokenizer) {
        try {
            return this._factory.findClass(string);
        }
        catch (Exception exception) {
            ClassUtil.throwIfRTE(exception);
            throw this._problem(myTokenizer, "Cannot locate class '" + string + "', problem: " + exception.getMessage());
        }
    }

    protected IllegalArgumentException _problem(MyTokenizer myTokenizer, String string) {
        return new IllegalArgumentException(String.format("Failed to parse type '%s' (remaining: '%s'): %s", myTokenizer.getAllInput(), myTokenizer.getRemainingInput(), string));
    }

    static final class MyTokenizer
    extends StringTokenizer {
        protected final String _input;
        protected int _index;
        protected String _pushbackToken;

        public MyTokenizer(String string) {
            super(string, "<,>", true);
            this._input = string;
        }

        @Override
        public boolean hasMoreTokens() {
            return this._pushbackToken != null || super.hasMoreTokens();
        }

        @Override
        public String nextToken() {
            String string;
            if (this._pushbackToken != null) {
                string = this._pushbackToken;
                this._pushbackToken = null;
            } else {
                string = super.nextToken();
                this._index += string.length();
                string = string.trim();
            }
            return string;
        }

        public void pushBack(String string) {
            this._pushbackToken = string;
        }

        public String getAllInput() {
            return this._input;
        }

        public String getRemainingInput() {
            return this._input.substring(this._index);
        }
    }
}

