/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.dataformat.xml;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.annotation.JsonTypeInfo;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.DatabindContext;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.JavaType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.cfg.MapperConfig;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsontype.NamedType;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsontype.PolymorphicTypeValidator;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsontype.TypeIdResolver;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsontype.impl.ClassNameIdResolver;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsontype.impl.MinimalClassNameIdResolver;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.jsontype.impl.StdTypeResolverBuilder;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.databind.type.TypeFactory;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.dataformat.xml.util.StaxUtil;
import java.io.IOException;
import java.util.Collection;

public class XmlTypeResolverBuilder
extends StdTypeResolverBuilder {
    @Override
    public StdTypeResolverBuilder init(JsonTypeInfo.Id id, TypeIdResolver typeIdResolver) {
        super.init(id, typeIdResolver);
        if (this._typeProperty != null) {
            this._typeProperty = StaxUtil.sanitizeXmlTypeName(this._typeProperty);
        }
        return this;
    }

    @Override
    public StdTypeResolverBuilder typeProperty(String string) {
        if (string == null || string.length() == 0) {
            string = this._idType.getDefaultPropertyName();
        }
        this._typeProperty = StaxUtil.sanitizeXmlTypeName(string);
        return this;
    }

    @Override
    protected TypeIdResolver idResolver(MapperConfig<?> mapperConfig, JavaType javaType, PolymorphicTypeValidator polymorphicTypeValidator, Collection<NamedType> collection, boolean bl2, boolean bl3) {
        if (this._customIdResolver != null) {
            return this._customIdResolver;
        }
        switch (this._idType) {
            case CLASS: {
                return new XmlClassNameIdResolver(javaType, mapperConfig.getTypeFactory(), this.subTypeValidator(mapperConfig));
            }
            case MINIMAL_CLASS: {
                return new XmlMinimalClassNameIdResolver(javaType, mapperConfig.getTypeFactory(), this.subTypeValidator(mapperConfig));
            }
        }
        return super.idResolver(mapperConfig, javaType, polymorphicTypeValidator, collection, bl2, bl3);
    }

    protected static String encodeXmlClassName(String string) {
        int n2 = string.lastIndexOf(36);
        if (n2 >= 0) {
            StringBuilder stringBuilder = new StringBuilder(string);
            do {
                stringBuilder.replace(n2, n2 + 1, "..");
            } while ((n2 = string.lastIndexOf(36, n2 - 1)) >= 0);
            string = stringBuilder.toString();
        }
        return string;
    }

    protected static String decodeXmlClassName(String string) {
        int n2 = string.lastIndexOf("..");
        if (n2 >= 0) {
            StringBuilder stringBuilder = new StringBuilder(string);
            do {
                stringBuilder.replace(n2, n2 + 2, "$");
            } while ((n2 = string.lastIndexOf("..", n2 - 1)) >= 0);
            string = stringBuilder.toString();
        }
        return string;
    }

    protected static class XmlMinimalClassNameIdResolver
    extends MinimalClassNameIdResolver {
        public XmlMinimalClassNameIdResolver(JavaType javaType, TypeFactory typeFactory, PolymorphicTypeValidator polymorphicTypeValidator) {
            super(javaType, typeFactory, polymorphicTypeValidator);
        }

        @Override
        public String idFromValue(Object object) {
            return XmlTypeResolverBuilder.encodeXmlClassName(super.idFromValue(object));
        }

        @Override
        public JavaType typeFromId(DatabindContext databindContext, String string) throws IOException {
            return super.typeFromId(databindContext, XmlTypeResolverBuilder.decodeXmlClassName(string));
        }
    }

    protected static class XmlClassNameIdResolver
    extends ClassNameIdResolver {
        public XmlClassNameIdResolver(JavaType javaType, TypeFactory typeFactory, PolymorphicTypeValidator polymorphicTypeValidator) {
            super(javaType, typeFactory, polymorphicTypeValidator);
        }

        @Override
        public String idFromValue(Object object) {
            return XmlTypeResolverBuilder.encodeXmlClassName(super.idFromValue(object));
        }

        @Override
        public JavaType typeFromId(DatabindContext databindContext, String string) throws IOException {
            return super.typeFromId(databindContext, XmlTypeResolverBuilder.decodeXmlClassName(string));
        }
    }
}

