/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.dataformat.xml.deser;

import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.Base64Variant;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.FormatFeature;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonLocation;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonParseException;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonParser;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.JsonToken;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.ObjectCodec;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.StreamReadCapability;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.Version;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.base.ParserMinimalBase;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.io.IOContext;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.io.NumberInput;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.util.ByteArrayBuilder;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.core.util.JacksonFeatureSet;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.dataformat.xml.PackageVersion;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.dataformat.xml.deser.XmlReadContext;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.dataformat.xml.deser.XmlTokenStream;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.dataformat.xml.util.CaseInsensitiveNameSet;
import com.ibm.cognos.externals.com.fasterxml.jackson_2_12_2.dataformat.xml.util.StaxUtil;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class FromXmlParser
extends ParserMinimalBase {
    public static final String DEFAULT_UNNAMED_TEXT_PROPERTY = "";
    protected static final JacksonFeatureSet<StreamReadCapability> XML_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES.with(StreamReadCapability.DUPLICATE_PROPERTIES).with(StreamReadCapability.SCALARS_AS_OBJECTS).with(StreamReadCapability.UNTYPED_SCALARS);
    protected String _cfgNameForTextElement = "";
    protected int _formatFeatures;
    protected ObjectCodec _objectCodec;
    protected boolean _closed;
    protected final IOContext _ioContext;
    protected XmlReadContext _parsingContext;
    protected final XmlTokenStream _xmlTokens;
    protected boolean _mayBeLeaf;
    protected JsonToken _nextToken;
    protected String _currText;
    protected ByteArrayBuilder _byteArrayBuilder = null;
    protected byte[] _binaryValue;
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected long _numberLong;
    protected BigInteger _numberBigInt;

    public FromXmlParser(IOContext iOContext, int n2, int n3, ObjectCodec objectCodec, XMLStreamReader xMLStreamReader) throws IOException {
        super(n2);
        int n4;
        this._formatFeatures = n3;
        this._ioContext = iOContext;
        this._objectCodec = objectCodec;
        this._parsingContext = XmlReadContext.createRootContext(-1, -1);
        this._xmlTokens = new XmlTokenStream(xMLStreamReader, iOContext.getSourceReference(), this._formatFeatures);
        try {
            n4 = this._xmlTokens.initialize();
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsParseException(xMLStreamException, this);
            return;
        }
        if (this._xmlTokens.hasXsiNil()) {
            this._nextToken = JsonToken.VALUE_NULL;
        } else {
            switch (n4) {
                case 1: 
                case 6: {
                    this._nextToken = JsonToken.START_OBJECT;
                    break;
                }
                case 7: {
                    this._currText = this._xmlTokens.getText();
                    if (this._currText == null) {
                        this._nextToken = JsonToken.VALUE_NULL;
                        break;
                    }
                    this._nextToken = JsonToken.VALUE_STRING;
                    break;
                }
                default: {
                    this._reportError("Internal problem: invalid starting state (%s)", this._xmlTokens._currentStateDesc());
                }
            }
        }
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    public void setXMLTextElementName(String string) {
        this._cfgNameForTextElement = string;
    }

    @Override
    public boolean requiresCustomCodec() {
        return true;
    }

    @Override
    public boolean canReadObjectId() {
        return false;
    }

    @Override
    public boolean canReadTypeId() {
        return false;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return XML_READ_CAPABILITIES;
    }

    public FromXmlParser enable(Feature feature) {
        this._formatFeatures |= feature.getMask();
        this._xmlTokens.setFormatFeatures(this._formatFeatures);
        return this;
    }

    public FromXmlParser disable(Feature feature) {
        this._formatFeatures &= ~feature.getMask();
        this._xmlTokens.setFormatFeatures(this._formatFeatures);
        return this;
    }

    public final boolean isEnabled(Feature feature) {
        return (this._formatFeatures & feature.getMask()) != 0;
    }

    public FromXmlParser configure(Feature feature, boolean bl2) {
        if (bl2) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    @Override
    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    @Override
    public JsonParser overrideFormatFeatures(int n2, int n3) {
        this._formatFeatures = this._formatFeatures & ~n3 | n2 & n3;
        this._xmlTokens.setFormatFeatures(this._formatFeatures);
        return this;
    }

    public XMLStreamReader getStaxReader() {
        return this._xmlTokens.getXmlReader();
    }

    public void addVirtualWrapping(Set<String> caseInsensitiveNameSet, boolean bl2) {
        String string;
        CaseInsensitiveNameSet caseInsensitiveNameSet2;
        CaseInsensitiveNameSet caseInsensitiveNameSet3 = caseInsensitiveNameSet2 = bl2 ? CaseInsensitiveNameSet.construct(caseInsensitiveNameSet) : caseInsensitiveNameSet;
        if (!this._parsingContext.inRoot() && !this._parsingContext.getParent().inRoot() && (string = this._xmlTokens.getLocalName()) != null && caseInsensitiveNameSet2.contains(string)) {
            this._xmlTokens.repeatStartElement();
        }
        this._parsingContext.setNamesToWrap(caseInsensitiveNameSet2);
    }

    @Deprecated
    public void addVirtualWrapping(Set<String> set) {
        this.addVirtualWrapping(set, false);
    }

    @Override
    public String getCurrentName() throws IOException {
        String string;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            XmlReadContext xmlReadContext = this._parsingContext.getParent();
            string = xmlReadContext.getCurrentName();
        } else {
            string = this._parsingContext.getCurrentName();
        }
        if (string == null) {
            throw new IllegalStateException("Missing name, in state: " + (Object)((Object)this._currToken));
        }
        return string;
    }

    @Override
    public void overrideCurrentName(String string) {
        XmlReadContext xmlReadContext = this._parsingContext;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            xmlReadContext = xmlReadContext.getParent();
        }
        xmlReadContext.setCurrentName(string);
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            try {
                if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                    this._xmlTokens.closeCompletely();
                } else {
                    this._xmlTokens.close();
                }
            }
            catch (XMLStreamException xMLStreamException) {
                StaxUtil.throwAsParseException(xMLStreamException, this);
            }
            finally {
                this._releaseBuffers();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public XmlReadContext getParsingContext() {
        return this._parsingContext;
    }

    @Override
    public JsonLocation getTokenLocation() {
        return this._xmlTokens.getTokenLocation();
    }

    @Override
    public JsonLocation getCurrentLocation() {
        return this._xmlTokens.getCurrentLocation();
    }

    @Override
    public boolean isExpectedStartArrayToken() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.START_OBJECT) {
            this._currToken = JsonToken.START_ARRAY;
            this._parsingContext.convertToArray();
            this._nextToken = this._nextToken == JsonToken.END_OBJECT ? JsonToken.END_ARRAY : null;
            this._xmlTokens.skipAttributes();
            return true;
        }
        return jsonToken == JsonToken.START_ARRAY;
    }

    @Override
    public boolean isExpectedNumberIntToken() {
        String string;
        int n2;
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING && (n2 = this._isIntNumber(string = this._currText.trim())) > 0) {
            boolean bl2;
            if (n2 <= 9) {
                this._numberInt = NumberInput.parseInt(string);
                this._numTypesValid = 1;
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return true;
            }
            if (n2 <= 18) {
                int n3;
                long l2;
                long l3 = NumberInput.parseLong(string);
                if (n2 == 10 && l3 == (l2 = (long)(n3 = (int)l3))) {
                    this._numberInt = n3;
                    this._numTypesValid = 1;
                    this._currToken = JsonToken.VALUE_NUMBER_INT;
                    return true;
                }
                this._numberLong = l3;
                this._numTypesValid = 2;
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return true;
            }
            if (n2 == 19 && (bl2 = string.charAt(0) == '-' ? NumberInput.inLongRange(string.substring(1), true) : NumberInput.inLongRange(string, false))) {
                this._numberLong = NumberInput.parseLong(string);
                this._numTypesValid = 2;
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return true;
            }
            this._numberBigInt = new BigInteger(string);
            this._numTypesValid = 4;
            this._currToken = JsonToken.VALUE_NUMBER_INT;
            return true;
        }
        return jsonToken == JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public JsonToken nextToken() throws IOException {
        this._binaryValue = null;
        this._numTypesValid = 0;
        if (this._nextToken != null) {
            JsonToken jsonToken;
            this._currToken = jsonToken = this._nextToken;
            this._nextToken = null;
            switch (jsonToken) {
                case START_OBJECT: {
                    this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                    break;
                }
                case START_ARRAY: {
                    this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    this._parsingContext = this._parsingContext.getParent();
                    break;
                }
                case FIELD_NAME: {
                    this._parsingContext.setCurrentName(this._xmlTokens.getLocalName());
                    break;
                }
                default: {
                    this._parsingContext.valueStarted();
                }
            }
            return jsonToken;
        }
        int n2 = this._nextToken();
        while (n2 == 1) {
            if (this._mayBeLeaf) {
                this._nextToken = JsonToken.FIELD_NAME;
                this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            if (this._parsingContext.inArray()) {
                n2 = this._nextToken();
                this._mayBeLeaf = true;
                continue;
            }
            String string = this._xmlTokens.getLocalName();
            this._parsingContext.setCurrentName(string);
            if (this._parsingContext.shouldWrap(string)) {
                this._xmlTokens.repeatStartElement();
            }
            this._mayBeLeaf = true;
            this._currToken = JsonToken.FIELD_NAME;
            return this._currToken;
        }
        block14: while (true) {
            switch (n2) {
                case 2: {
                    if (this._mayBeLeaf) {
                        this._mayBeLeaf = false;
                        if (this._parsingContext.inArray()) {
                            this._nextToken = JsonToken.END_OBJECT;
                            this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                            this._currToken = JsonToken.START_OBJECT;
                            return this._currToken;
                        }
                        if (this._currToken != JsonToken.VALUE_NULL) {
                            this._parsingContext.valueStarted();
                            this._currToken = JsonToken.VALUE_NULL;
                            return this._currToken;
                        }
                    }
                    this._currToken = this._parsingContext.inArray() ? JsonToken.END_ARRAY : JsonToken.END_OBJECT;
                    this._parsingContext = this._parsingContext.getParent();
                    return this._currToken;
                }
                case 3: {
                    if (this._mayBeLeaf) {
                        this._mayBeLeaf = false;
                        this._nextToken = JsonToken.FIELD_NAME;
                        this._currText = this._xmlTokens.getText();
                        this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                        this._currToken = JsonToken.START_OBJECT;
                        return this._currToken;
                    }
                    this._parsingContext.setCurrentName(this._xmlTokens.getLocalName());
                    this._currToken = JsonToken.FIELD_NAME;
                    return this._currToken;
                }
                case 4: {
                    this._currText = this._xmlTokens.getText();
                    this._parsingContext.valueStarted();
                    this._currToken = JsonToken.VALUE_STRING;
                    return this._currToken;
                }
                case 5: {
                    this._currText = this._xmlTokens.getText();
                    if (this._mayBeLeaf) {
                        this._mayBeLeaf = false;
                        n2 = this._nextToken();
                        if (n2 == 2) {
                            if (this._parsingContext.inArray() && XmlTokenStream._allWs(this._currText)) {
                                this._nextToken = JsonToken.END_OBJECT;
                                this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                                this._currToken = JsonToken.START_OBJECT;
                                return this._currToken;
                            }
                            this._currToken = JsonToken.VALUE_STRING;
                            return this._currToken;
                        }
                        if (n2 != 1) {
                            throw new JsonParseException(this, String.format("Internal error: Expected END_ELEMENT (%d) or START_ELEMENT (%d), got event of type %d", 2, 1, n2));
                        }
                        this._xmlTokens.pushbackCurrentToken();
                        this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                    }
                    if (this._parsingContext.inObject()) {
                        if (this._currToken != JsonToken.FIELD_NAME && XmlTokenStream._allWs(this._currText)) {
                            n2 = this._nextToken();
                            continue block14;
                        }
                    } else if (this._parsingContext.inArray() && XmlTokenStream._allWs(this._currText)) {
                        n2 = this._nextToken();
                        continue block14;
                    }
                    this._parsingContext.setCurrentName(this._cfgNameForTextElement);
                    this._nextToken = JsonToken.VALUE_STRING;
                    this._currToken = JsonToken.FIELD_NAME;
                    return this._currToken;
                }
                case 8: {
                    this._currToken = null;
                    return null;
                }
            }
            break;
        }
        return (JsonToken)((Object)this._internalErrorUnknownToken(n2));
    }

    @Override
    public String nextTextValue() throws IOException {
        this._binaryValue = null;
        if (this._nextToken != null) {
            JsonToken jsonToken;
            this._currToken = jsonToken = this._nextToken;
            this._nextToken = null;
            if (jsonToken == JsonToken.VALUE_STRING) {
                this._parsingContext.valueStarted();
                return this._currText;
            }
            this._updateState(jsonToken);
            return null;
        }
        int n2 = this._nextToken();
        while (n2 == 1) {
            if (this._mayBeLeaf) {
                this._nextToken = JsonToken.FIELD_NAME;
                this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                this._currToken = JsonToken.START_OBJECT;
                return null;
            }
            if (this._parsingContext.inArray()) {
                n2 = this._nextToken();
                this._mayBeLeaf = true;
                continue;
            }
            String string = this._xmlTokens.getLocalName();
            this._parsingContext.setCurrentName(string);
            if (this._parsingContext.shouldWrap(string)) {
                this._xmlTokens.repeatStartElement();
            }
            this._mayBeLeaf = true;
            this._currToken = JsonToken.FIELD_NAME;
            return null;
        }
        switch (n2) {
            case 2: {
                if (this._mayBeLeaf) {
                    this._mayBeLeaf = false;
                    this._currToken = JsonToken.VALUE_STRING;
                    this._parsingContext.valueStarted();
                    this._currText = DEFAULT_UNNAMED_TEXT_PROPERTY;
                    return DEFAULT_UNNAMED_TEXT_PROPERTY;
                }
                this._currToken = this._parsingContext.inArray() ? JsonToken.END_ARRAY : JsonToken.END_OBJECT;
                this._parsingContext = this._parsingContext.getParent();
                break;
            }
            case 3: {
                if (this._mayBeLeaf) {
                    this._mayBeLeaf = false;
                    this._nextToken = JsonToken.FIELD_NAME;
                    this._currText = this._xmlTokens.getText();
                    this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                    this._currToken = JsonToken.START_OBJECT;
                    break;
                }
                this._parsingContext.setCurrentName(this._xmlTokens.getLocalName());
                this._currToken = JsonToken.FIELD_NAME;
                break;
            }
            case 4: {
                this._currToken = JsonToken.VALUE_STRING;
                this._parsingContext.valueStarted();
                this._currText = this._xmlTokens.getText();
                return this._currText;
            }
            case 5: {
                this._currText = this._xmlTokens.getText();
                if (this._mayBeLeaf) {
                    this._mayBeLeaf = false;
                    this._skipEndElement();
                    this._parsingContext.valueStarted();
                    this._currToken = JsonToken.VALUE_STRING;
                    return this._currText;
                }
                this._parsingContext.setCurrentName(this._cfgNameForTextElement);
                this._nextToken = JsonToken.VALUE_STRING;
                this._currToken = JsonToken.FIELD_NAME;
                break;
            }
            case 8: {
                this._currToken = null;
            }
            default: {
                return (String)this._internalErrorUnknownToken(n2);
            }
        }
        return null;
    }

    private void _updateState(JsonToken jsonToken) {
        switch (jsonToken) {
            case START_OBJECT: {
                this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                break;
            }
            case START_ARRAY: {
                this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
                break;
            }
            case END_OBJECT: 
            case END_ARRAY: {
                this._parsingContext = this._parsingContext.getParent();
                break;
            }
            case FIELD_NAME: {
                this._parsingContext.setCurrentName(this._xmlTokens.getLocalName());
                break;
            }
            default: {
                this._internalErrorUnknownToken((Object)jsonToken);
            }
        }
    }

    @Override
    public String getText() throws IOException {
        if (this._currToken == null) {
            return null;
        }
        switch (this._currToken) {
            case FIELD_NAME: {
                return this.getCurrentName();
            }
            case VALUE_STRING: {
                return this._currText;
            }
        }
        return this._currToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        String string = this.getText();
        return string == null ? null : string.toCharArray();
    }

    @Override
    public int getTextLength() throws IOException {
        String string = this.getText();
        return string == null ? 0 : string.length();
    }

    @Override
    public int getTextOffset() throws IOException {
        return 0;
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public int getText(Writer writer) throws IOException {
        String string = this.getText();
        if (string == null) {
            return 0;
        }
        writer.write(string);
        return string.length();
    }

    @Override
    public Object getEmbeddedObject() throws IOException {
        return null;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._binaryValue == null) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
        }
        return this._binaryValue;
    }

    protected byte[] _decodeBase64(Base64Variant base64Variant) throws IOException {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        String string = this.getText();
        this._decodeBase64(string, byteArrayBuilder, base64Variant);
        return byteArrayBuilder.toByteArray();
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException {
        if (this._numTypesValid == 0) {
            this._checkNumericValue(0);
        }
        if ((this._numTypesValid & 1) != 0) {
            return JsonParser.NumberType.INT;
        }
        if ((this._numTypesValid & 2) != 0) {
            return JsonParser.NumberType.LONG;
        }
        return JsonParser.NumberType.BIG_INTEGER;
    }

    @Override
    public Number getNumberValue() throws IOException {
        if (this._numTypesValid == 0) {
            this._checkNumericValue(0);
        }
        if ((this._numTypesValid & 1) != 0) {
            return this._numberInt;
        }
        if ((this._numTypesValid & 2) != 0) {
            return this._numberLong;
        }
        if ((this._numTypesValid & 4) != 0) {
            return this._numberBigInt;
        }
        this._throwInternal();
        return null;
    }

    @Override
    public int getIntValue() throws IOException {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(1);
            }
            if ((this._numTypesValid & 1) == 0) {
                this._convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    @Override
    public long getLongValue() throws IOException {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this._convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._checkNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this._convertNumberToBigInteger();
            }
        }
        return this._numberBigInt;
    }

    @Override
    public float getFloatValue() throws IOException {
        if ((this._numTypesValid & 0x20) == 0 && this._numTypesValid == 0) {
            this._checkNumericValue(32);
        }
        return this._convertNumberToFloat();
    }

    @Override
    public double getDoubleValue() throws IOException {
        if ((this._numTypesValid & 8) == 0 && this._numTypesValid == 0) {
            this._checkNumericValue(8);
        }
        return this._convertNumberToDouble();
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        if ((this._numTypesValid & 0x10) == 0 && this._numTypesValid == 0) {
            this._checkNumericValue(16);
        }
        return this._convertNumberToBigDecimal();
    }

    protected final void _checkNumericValue(int n2) throws IOException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            return;
        }
        this._reportError("Current token (" + (Object)((Object)this.currentToken()) + ") not numeric, can not use numeric value accessors");
    }

    protected final int _isIntNumber(String string) {
        int n2 = string.length();
        if (n2 > 0) {
            int n3;
            for (int i2 = n3 = (var3_3 = string.charAt(0)) == '-' ? 1 : 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 <= '9' && c2 >= '0') continue;
                return -1;
            }
            return n2 - n3;
        }
        return 0;
    }

    protected void _convertNumberToInt() throws IOException {
        if ((this._numTypesValid & 2) != 0) {
            int n2 = (int)this._numberLong;
            if ((long)n2 != this._numberLong) {
                this._reportError("Numeric value (" + this.getText() + ") out of range of int");
            }
            this._numberInt = n2;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_INT.compareTo(this._numberBigInt) > 0 || BI_MAX_INT.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigInt.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected void _convertNumberToLong() throws IOException {
        if ((this._numTypesValid & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((this._numTypesValid & 4) != 0) {
            if (BI_MIN_LONG.compareTo(this._numberBigInt) > 0 || BI_MAX_LONG.compareTo(this._numberBigInt) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigInt.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected void _convertNumberToBigInteger() throws IOException {
        if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected float _convertNumberToFloat() throws IOException {
        if ((this._numTypesValid & 4) != 0) {
            return this._numberBigInt.floatValue();
        }
        if ((this._numTypesValid & 2) != 0) {
            return this._numberLong;
        }
        if ((this._numTypesValid & 1) != 0) {
            return this._numberInt;
        }
        this._throwInternal();
        return 0.0f;
    }

    protected double _convertNumberToDouble() throws IOException {
        if ((this._numTypesValid & 4) != 0) {
            return this._numberBigInt.doubleValue();
        }
        if ((this._numTypesValid & 2) != 0) {
            return this._numberLong;
        }
        if ((this._numTypesValid & 1) != 0) {
            return this._numberInt;
        }
        this._throwInternal();
        return 0.0;
    }

    protected BigDecimal _convertNumberToBigDecimal() throws IOException {
        if ((this._numTypesValid & 4) != 0) {
            return new BigDecimal(this._numberBigInt);
        }
        if ((this._numTypesValid & 2) != 0) {
            return BigDecimal.valueOf(this._numberLong);
        }
        if ((this._numTypesValid & 1) != 0) {
            return BigDecimal.valueOf(this._numberInt);
        }
        this._throwInternal();
        return null;
    }

    @Override
    protected void _handleEOF() throws JsonParseException {
        if (!this._parsingContext.inRoot()) {
            String string = this._parsingContext.inArray() ? "Array" : "Object";
            this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", string, this._parsingContext.getStartLocation(this._ioContext.getSourceReference())), null);
        }
    }

    protected void _releaseBuffers() throws IOException {
    }

    protected ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    private <T> T _internalErrorUnknownToken(Object object) {
        throw new IllegalStateException("Internal error: unrecognized XmlTokenStream token: " + object);
    }

    protected int _nextToken() throws IOException {
        try {
            return this._xmlTokens.next();
        }
        catch (XMLStreamException xMLStreamException) {
            return (Integer)StaxUtil.throwAsParseException(xMLStreamException, this);
        }
    }

    protected void _skipEndElement() throws IOException {
        try {
            this._xmlTokens.skipEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            StaxUtil.throwAsParseException(xMLStreamException, this);
        }
        catch (Exception exception) {
            throw new JsonParseException((JsonParser)this, exception.getMessage(), (Throwable)exception);
        }
    }

    public static enum Feature implements FormatFeature
    {
        EMPTY_ELEMENT_AS_NULL(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int n2 = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n2 |= feature.getMask();
            }
            return n2;
        }

        private Feature(boolean bl2) {
            this._defaultState = bl2;
            this._mask = 1 << this.ordinal();
        }

        @Override
        public boolean enabledByDefault() {
            return this._defaultState;
        }

        @Override
        public int getMask() {
            return this._mask;
        }

        @Override
        public boolean enabledIn(int n2) {
            return (n2 & this.getMask()) != 0;
        }
    }
}

