/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_1_15.codec.binary;

import com.ibm.cognos.externals.org.apache.commons_1_15.codec.binary.BaseNCodec;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class BaseNCodecInputStream
extends FilterInputStream {
    private final BaseNCodec baseNCodec;
    private final boolean doEncode;
    private final byte[] singleByte = new byte[1];
    private final BaseNCodec.Context context = new BaseNCodec.Context();

    protected BaseNCodecInputStream(InputStream inputStream, BaseNCodec baseNCodec, boolean bl2) {
        super(inputStream);
        this.doEncode = bl2;
        this.baseNCodec = baseNCodec;
    }

    @Override
    public int available() throws IOException {
        return this.context.eof ? 0 : 1;
    }

    public boolean isStrictDecoding() {
        return this.baseNCodec.isStrictDecoding();
    }

    @Override
    public synchronized void mark(int n2) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int n2 = this.read(this.singleByte, 0, 1);
        while (n2 == 0) {
            n2 = this.read(this.singleByte, 0, 1);
        }
        if (n2 > 0) {
            int n3 = this.singleByte[0];
            return n3 < 0 ? 256 + n3 : n3;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        Objects.requireNonNull(byArray, "array");
        if (n2 < 0 || n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 > byArray.length || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = 0;
        while (n4 == 0) {
            if (!this.baseNCodec.hasData(this.context)) {
                byte[] byArray2 = new byte[this.doEncode ? 4096 : 8192];
                int n5 = this.in.read(byArray2);
                if (this.doEncode) {
                    this.baseNCodec.encode(byArray2, 0, n5, this.context);
                } else {
                    this.baseNCodec.decode(byArray2, 0, n5, this.context);
                }
            }
            n4 = this.baseNCodec.readResults(byArray, n2, n3, this.context);
        }
        return n4;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3;
        int n2;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative skip length: " + l2);
        }
        byte[] byArray = new byte[512];
        for (l3 = l2; l3 > 0L; l3 -= (long)n2) {
            n2 = (int)Math.min((long)byArray.length, l3);
            if ((n2 = this.read(byArray, 0, n2)) == -1) break;
        }
        return l2 - l3;
    }
}

