/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EndianUtils {
    public static short swapShort(short s2) {
        return (short)(((s2 >> 0 & 0xFF) << 8) + ((s2 >> 8 & 0xFF) << 0));
    }

    public static int swapInteger(int n2) {
        return ((n2 >> 0 & 0xFF) << 24) + ((n2 >> 8 & 0xFF) << 16) + ((n2 >> 16 & 0xFF) << 8) + ((n2 >> 24 & 0xFF) << 0);
    }

    public static long swapLong(long l2) {
        return ((l2 >> 0 & 0xFFL) << 56) + ((l2 >> 8 & 0xFFL) << 48) + ((l2 >> 16 & 0xFFL) << 40) + ((l2 >> 24 & 0xFFL) << 32) + ((l2 >> 32 & 0xFFL) << 24) + ((l2 >> 40 & 0xFFL) << 16) + ((l2 >> 48 & 0xFFL) << 8) + ((l2 >> 56 & 0xFFL) << 0);
    }

    public static float swapFloat(float f2) {
        return Float.intBitsToFloat(EndianUtils.swapInteger(Float.floatToIntBits(f2)));
    }

    public static double swapDouble(double d2) {
        return Double.longBitsToDouble(EndianUtils.swapLong(Double.doubleToLongBits(d2)));
    }

    public static void writeSwappedShort(byte[] byArray, int n2, short s2) {
        byArray[n2 + 0] = (byte)(s2 >> 0 & 0xFF);
        byArray[n2 + 1] = (byte)(s2 >> 8 & 0xFF);
    }

    public static short readSwappedShort(byte[] byArray, int n2) {
        return (short)(((byArray[n2 + 0] & 0xFF) << 0) + ((byArray[n2 + 1] & 0xFF) << 8));
    }

    public static int readSwappedUnsignedShort(byte[] byArray, int n2) {
        return ((byArray[n2 + 0] & 0xFF) << 0) + ((byArray[n2 + 1] & 0xFF) << 8);
    }

    public static void writeSwappedInteger(byte[] byArray, int n2, int n3) {
        byArray[n2 + 0] = (byte)(n3 >> 0 & 0xFF);
        byArray[n2 + 1] = (byte)(n3 >> 8 & 0xFF);
        byArray[n2 + 2] = (byte)(n3 >> 16 & 0xFF);
        byArray[n2 + 3] = (byte)(n3 >> 24 & 0xFF);
    }

    public static int readSwappedInteger(byte[] byArray, int n2) {
        return ((byArray[n2 + 0] & 0xFF) << 0) + ((byArray[n2 + 1] & 0xFF) << 8) + ((byArray[n2 + 2] & 0xFF) << 16) + ((byArray[n2 + 3] & 0xFF) << 24);
    }

    public static long readSwappedUnsignedInteger(byte[] byArray, int n2) {
        long l2 = ((byArray[n2 + 0] & 0xFF) << 0) + ((byArray[n2 + 1] & 0xFF) << 8) + ((byArray[n2 + 2] & 0xFF) << 16);
        long l3 = byArray[n2 + 3] & 0xFF;
        return (l3 << 24) + (0xFFFFFFFFL & l2);
    }

    public static void writeSwappedLong(byte[] byArray, int n2, long l2) {
        byArray[n2 + 0] = (byte)(l2 >> 0 & 0xFFL);
        byArray[n2 + 1] = (byte)(l2 >> 8 & 0xFFL);
        byArray[n2 + 2] = (byte)(l2 >> 16 & 0xFFL);
        byArray[n2 + 3] = (byte)(l2 >> 24 & 0xFFL);
        byArray[n2 + 4] = (byte)(l2 >> 32 & 0xFFL);
        byArray[n2 + 5] = (byte)(l2 >> 40 & 0xFFL);
        byArray[n2 + 6] = (byte)(l2 >> 48 & 0xFFL);
        byArray[n2 + 7] = (byte)(l2 >> 56 & 0xFFL);
    }

    public static long readSwappedLong(byte[] byArray, int n2) {
        long l2 = EndianUtils.readSwappedInteger(byArray, n2);
        long l3 = EndianUtils.readSwappedInteger(byArray, n2 + 4);
        return (l3 << 32) + (0xFFFFFFFFL & l2);
    }

    public static void writeSwappedFloat(byte[] byArray, int n2, float f2) {
        EndianUtils.writeSwappedInteger(byArray, n2, Float.floatToIntBits(f2));
    }

    public static float readSwappedFloat(byte[] byArray, int n2) {
        return Float.intBitsToFloat(EndianUtils.readSwappedInteger(byArray, n2));
    }

    public static void writeSwappedDouble(byte[] byArray, int n2, double d2) {
        EndianUtils.writeSwappedLong(byArray, n2, Double.doubleToLongBits(d2));
    }

    public static double readSwappedDouble(byte[] byArray, int n2) {
        return Double.longBitsToDouble(EndianUtils.readSwappedLong(byArray, n2));
    }

    public static void writeSwappedShort(OutputStream outputStream, short s2) throws IOException {
        outputStream.write((byte)(s2 >> 0 & 0xFF));
        outputStream.write((byte)(s2 >> 8 & 0xFF));
    }

    public static short readSwappedShort(InputStream inputStream) throws IOException {
        return (short)(((EndianUtils.read(inputStream) & 0xFF) << 0) + ((EndianUtils.read(inputStream) & 0xFF) << 8));
    }

    public static int readSwappedUnsignedShort(InputStream inputStream) throws IOException {
        int n2 = EndianUtils.read(inputStream);
        int n3 = EndianUtils.read(inputStream);
        return ((n2 & 0xFF) << 0) + ((n3 & 0xFF) << 8);
    }

    public static void writeSwappedInteger(OutputStream outputStream, int n2) throws IOException {
        outputStream.write((byte)(n2 >> 0 & 0xFF));
        outputStream.write((byte)(n2 >> 8 & 0xFF));
        outputStream.write((byte)(n2 >> 16 & 0xFF));
        outputStream.write((byte)(n2 >> 24 & 0xFF));
    }

    public static int readSwappedInteger(InputStream inputStream) throws IOException {
        int n2 = EndianUtils.read(inputStream);
        int n3 = EndianUtils.read(inputStream);
        int n4 = EndianUtils.read(inputStream);
        int n5 = EndianUtils.read(inputStream);
        return ((n2 & 0xFF) << 0) + ((n3 & 0xFF) << 8) + ((n4 & 0xFF) << 16) + ((n5 & 0xFF) << 24);
    }

    public static long readSwappedUnsignedInteger(InputStream inputStream) throws IOException {
        int n2 = EndianUtils.read(inputStream);
        int n3 = EndianUtils.read(inputStream);
        int n4 = EndianUtils.read(inputStream);
        int n5 = EndianUtils.read(inputStream);
        long l2 = ((n2 & 0xFF) << 0) + ((n3 & 0xFF) << 8) + ((n4 & 0xFF) << 16);
        long l3 = n5 & 0xFF;
        return (l3 << 24) + (0xFFFFFFFFL & l2);
    }

    public static void writeSwappedLong(OutputStream outputStream, long l2) throws IOException {
        outputStream.write((byte)(l2 >> 0 & 0xFFL));
        outputStream.write((byte)(l2 >> 8 & 0xFFL));
        outputStream.write((byte)(l2 >> 16 & 0xFFL));
        outputStream.write((byte)(l2 >> 24 & 0xFFL));
        outputStream.write((byte)(l2 >> 32 & 0xFFL));
        outputStream.write((byte)(l2 >> 40 & 0xFFL));
        outputStream.write((byte)(l2 >> 48 & 0xFFL));
        outputStream.write((byte)(l2 >> 56 & 0xFFL));
    }

    public static long readSwappedLong(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[i2] = (byte)EndianUtils.read(inputStream);
        }
        return EndianUtils.readSwappedLong(byArray, 0);
    }

    public static void writeSwappedFloat(OutputStream outputStream, float f2) throws IOException {
        EndianUtils.writeSwappedInteger(outputStream, Float.floatToIntBits(f2));
    }

    public static float readSwappedFloat(InputStream inputStream) throws IOException {
        return Float.intBitsToFloat(EndianUtils.readSwappedInteger(inputStream));
    }

    public static void writeSwappedDouble(OutputStream outputStream, double d2) throws IOException {
        EndianUtils.writeSwappedLong(outputStream, Double.doubleToLongBits(d2));
    }

    public static double readSwappedDouble(InputStream inputStream) throws IOException {
        return Double.longBitsToDouble(EndianUtils.readSwappedLong(inputStream));
    }

    private static int read(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        if (-1 == n2) {
            throw new EOFException("Unexpected EOF reached");
        }
        return n2;
    }
}

