/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.Counters;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.CountingPathVisitor;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.DeleteOption;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.PathUtils;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.file.StandardDeleteOption;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Objects;

public class CleaningPathVisitor
extends CountingPathVisitor {
    private final String[] skip;
    private final boolean overrideReadOnly;

    public static CountingPathVisitor withBigIntegerCounters() {
        return new CleaningPathVisitor(Counters.bigIntegerPathCounters(), new String[0]);
    }

    public static CountingPathVisitor withLongCounters() {
        return new CleaningPathVisitor(Counters.longPathCounters(), new String[0]);
    }

    public CleaningPathVisitor(Counters.PathCounters pathCounters, DeleteOption[] deleteOptionArray, String ... stringArray) {
        super(pathCounters);
        Object[] objectArray = stringArray != null ? (String[])stringArray.clone() : EMPTY_STRING_ARRAY;
        Arrays.sort(objectArray);
        this.skip = objectArray;
        this.overrideReadOnly = StandardDeleteOption.overrideReadOnly(deleteOptionArray);
    }

    public CleaningPathVisitor(Counters.PathCounters pathCounters, String ... stringArray) {
        this(pathCounters, PathUtils.EMPTY_DELETE_OPTION_ARRAY, stringArray);
    }

    private boolean accept(Path path) {
        return Arrays.binarySearch(this.skip, Objects.toString(path.getFileName(), null)) < 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CleaningPathVisitor cleaningPathVisitor = (CleaningPathVisitor)object;
        return this.overrideReadOnly == cleaningPathVisitor.overrideReadOnly && Arrays.equals(this.skip, cleaningPathVisitor.skip);
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + Arrays.hashCode(this.skip);
        n3 = 31 * n3 + Objects.hash(this.overrideReadOnly);
        return n3;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        super.preVisitDirectory(path, basicFileAttributes);
        return this.accept(path) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        if (this.accept(path) && Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            if (this.overrideReadOnly) {
                PathUtils.setReadOnly(path, false, LinkOption.NOFOLLOW_LINKS);
            }
            Files.deleteIfExists(path);
        }
        this.updateFileCounters(path, basicFileAttributes);
        return FileVisitResult.CONTINUE;
    }
}

