/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.filefilter;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.filefilter.AbstractFileFilter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;

public class MagicNumberFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = -547733176983104172L;
    private final byte[] magicNumbers;
    private final long byteOffset;

    public MagicNumberFileFilter(byte[] byArray) {
        this(byArray, 0L);
    }

    public MagicNumberFileFilter(String string) {
        this(string, 0L);
    }

    public MagicNumberFileFilter(String string, long l2) {
        if (string == null) {
            throw new IllegalArgumentException("The magic number cannot be null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("The magic number must contain at least one byte");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("The offset cannot be negative");
        }
        this.magicNumbers = string.getBytes(Charset.defaultCharset());
        this.byteOffset = l2;
    }

    public MagicNumberFileFilter(byte[] byArray, long l2) {
        if (byArray == null) {
            throw new IllegalArgumentException("The magic number cannot be null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("The magic number must contain at least one byte");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("The offset cannot be negative");
        }
        this.magicNumbers = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.magicNumbers, 0, byArray.length);
        this.byteOffset = l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean accept(File file) {
        if (file == null) return false;
        if (!file.isFile()) return false;
        if (!file.canRead()) return false;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            byte[] byArray = new byte[this.magicNumbers.length];
            randomAccessFile.seek(this.byteOffset);
            int n2 = randomAccessFile.read(byArray);
            if (n2 != this.magicNumbers.length) {
                boolean bl3 = false;
                return bl3;
            }
            boolean bl2 = Arrays.equals(this.magicNumbers, byArray);
            return bl2;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("(");
        stringBuilder.append(new String(this.magicNumbers, Charset.defaultCharset()));
        stringBuilder.append(",");
        stringBuilder.append(this.byteOffset);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

