/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.input;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class SequenceReader
extends Reader {
    private Reader reader;
    private Iterator<? extends Reader> readers;

    public SequenceReader(Iterable<? extends Reader> iterable) {
        this.readers = Objects.requireNonNull(iterable, "readers").iterator();
        this.reader = this.nextReader();
    }

    public SequenceReader(Reader ... readerArray) {
        this(Arrays.asList(readerArray));
    }

    @Override
    public void close() throws IOException {
        this.readers = null;
        this.reader = null;
    }

    private Reader nextReader() {
        return this.readers.hasNext() ? this.readers.next() : null;
    }

    @Override
    public int read() throws IOException {
        int n2 = -1;
        while (this.reader != null && (n2 = this.reader.read()) == -1) {
            this.reader = this.nextReader();
        }
        return n2;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        Objects.requireNonNull(cArray, "cbuf");
        if (n3 < 0 || n2 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("Array Size=" + cArray.length + ", offset=" + n2 + ", length=" + n3);
        }
        int n4 = 0;
        while (this.reader != null) {
            int n5 = this.reader.read(cArray, n2, n3);
            if (n5 == -1) {
                this.reader = this.nextReader();
                continue;
            }
            n4 += n5;
            n2 += n5;
            if ((n3 -= n5) > 0) continue;
            break;
        }
        if (n4 > 0) {
            return n4;
        }
        return -1;
    }
}

