/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.input.buffer;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.input.buffer.CircularByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class CircularBufferInputStream
extends InputStream {
    protected final InputStream in;
    protected final CircularByteBuffer buffer;
    protected final int bufferSize;
    private boolean eofSeen;

    public CircularBufferInputStream(InputStream inputStream, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Invalid bufferSize: " + n2);
        }
        this.in = Objects.requireNonNull(inputStream, "inputStream");
        this.buffer = new CircularByteBuffer(n2);
        this.bufferSize = n2;
        this.eofSeen = false;
    }

    public CircularBufferInputStream(InputStream inputStream) {
        this(inputStream, 8192);
    }

    protected void fillBuffer() throws IOException {
        if (this.eofSeen) {
            return;
        }
        int n2 = this.buffer.getSpace();
        byte[] byArray = new byte[n2];
        while (n2 > 0) {
            int n3 = this.in.read(byArray, 0, n2);
            if (n3 == -1) {
                this.eofSeen = true;
                return;
            }
            if (n3 <= 0) continue;
            this.buffer.add(byArray, 0, n3);
            n2 -= n3;
        }
    }

    protected boolean haveBytes(int n2) throws IOException {
        if (this.buffer.getCurrentNumberOfBytes() < n2) {
            this.fillBuffer();
        }
        return this.buffer.hasBytes();
    }

    @Override
    public int read() throws IOException {
        if (!this.haveBytes(1)) {
            return -1;
        }
        return this.buffer.read() & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        Objects.requireNonNull(byArray, "Buffer");
        if (n2 < 0) {
            throw new IllegalArgumentException("Offset must not be negative");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Length must not be negative");
        }
        if (!this.haveBytes(n3)) {
            return -1;
        }
        int n4 = Math.min(n3, this.buffer.getCurrentNumberOfBytes());
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray[n2 + i2] = this.buffer.read();
        }
        return n4;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.eofSeen = true;
        this.buffer.clear();
    }
}

