/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.output;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.FileUtils;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.IOUtils;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.output.ByteArrayOutputStream;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.output.ThresholdingOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DeferredFileOutputStream
extends ThresholdingOutputStream {
    private ByteArrayOutputStream memoryOutputStream;
    private OutputStream currentOutputStream;
    private File outputFile;
    private final String prefix;
    private final String suffix;
    private final File directory;
    private boolean closed = false;

    public DeferredFileOutputStream(int n2, File file) {
        this(n2, file, null, null, null, 1024);
    }

    public DeferredFileOutputStream(int n2, int n3, File file) {
        this(n2, file, null, null, null, n3);
        if (n3 < 0) {
            throw new IllegalArgumentException("Initial buffer size must be atleast 0.");
        }
    }

    public DeferredFileOutputStream(int n2, String string, String string2, File file) {
        this(n2, null, string, string2, file, 1024);
        if (string == null) {
            throw new IllegalArgumentException("Temporary file prefix is missing");
        }
    }

    public DeferredFileOutputStream(int n2, int n3, String string, String string2, File file) {
        this(n2, null, string, string2, file, n3);
        if (string == null) {
            throw new IllegalArgumentException("Temporary file prefix is missing");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Initial buffer size must be atleast 0.");
        }
    }

    private DeferredFileOutputStream(int n2, File file, String string, String string2, File file2, int n3) {
        super(n2);
        this.outputFile = file;
        this.prefix = string;
        this.suffix = string2;
        this.directory = file2;
        this.memoryOutputStream = new ByteArrayOutputStream(n3);
        this.currentOutputStream = this.memoryOutputStream;
    }

    @Override
    protected OutputStream getStream() throws IOException {
        return this.currentOutputStream;
    }

    @Override
    protected void thresholdReached() throws IOException {
        if (this.prefix != null) {
            this.outputFile = File.createTempFile(this.prefix, this.suffix, this.directory);
        }
        FileUtils.forceMkdirParent(this.outputFile);
        FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile);
        try {
            this.memoryOutputStream.writeTo(fileOutputStream);
        }
        catch (IOException iOException) {
            fileOutputStream.close();
            throw iOException;
        }
        this.currentOutputStream = fileOutputStream;
        this.memoryOutputStream = null;
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    public byte[] getData() {
        if (this.memoryOutputStream != null) {
            return this.memoryOutputStream.toByteArray();
        }
        return null;
    }

    public File getFile() {
        return this.outputFile;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        if (!this.closed) {
            throw new IOException("Stream not closed");
        }
        if (this.isInMemory()) {
            this.memoryOutputStream.writeTo(outputStream);
        } else {
            try (FileInputStream fileInputStream = new FileInputStream(this.outputFile);){
                IOUtils.copy((InputStream)fileInputStream, outputStream);
            }
        }
    }
}

