/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.commons_2_8_0.io.output;

import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.input.UnsynchronizedByteArrayInputStream;
import com.ibm.cognos.externals.org.apache.commons_2_8_0.io.output.AbstractByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class UnsynchronizedByteArrayOutputStream
extends AbstractByteArrayOutputStream {
    public UnsynchronizedByteArrayOutputStream() {
        this(1024);
    }

    public UnsynchronizedByteArrayOutputStream(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n2);
        }
        this.needNewBuffer(n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException(String.format("offset=%,d, length=%,d", n2, n3));
        }
        if (n3 == 0) {
            return;
        }
        this.writeImpl(byArray, n2, n3);
    }

    @Override
    public void write(int n2) {
        this.writeImpl(n2);
    }

    @Override
    public int write(InputStream inputStream) throws IOException {
        return this.writeImpl(inputStream);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public void reset() {
        this.resetImpl();
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        this.writeToImpl(outputStream);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream) throws IOException {
        return UnsynchronizedByteArrayOutputStream.toBufferedInputStream(inputStream, 1024);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream, int n2) throws IOException {
        try (UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream = new UnsynchronizedByteArrayOutputStream(n2);){
            unsynchronizedByteArrayOutputStream.write(inputStream);
            InputStream inputStream2 = unsynchronizedByteArrayOutputStream.toInputStream();
            return inputStream2;
        }
    }

    @Override
    public InputStream toInputStream() {
        return this.toInputStream(UnsynchronizedByteArrayInputStream::new);
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArrayImpl();
    }
}

