/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io;

import com.ibm.cognos.externals.org.apache.http_4_4_14.MessageConstraintException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.config.MessageConstraints;
import com.ibm.cognos.externals.org.apache.http_4_4_14.impl.io.HttpTransportMetricsImpl;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.BufferInfo;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.HttpTransportMetrics;
import com.ibm.cognos.externals.org.apache.http_4_4_14.io.SessionInputBuffer;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Asserts;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.ByteArrayBuffer;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.CharArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class SessionInputBufferImpl
implements BufferInfo,
SessionInputBuffer {
    private final HttpTransportMetricsImpl metrics;
    private final byte[] buffer;
    private final ByteArrayBuffer lineBuffer;
    private final int minChunkLimit;
    private final MessageConstraints constraints;
    private final CharsetDecoder decoder;
    private InputStream inStream;
    private int bufferPos;
    private int bufferLen;
    private CharBuffer cbuf;

    public SessionInputBufferImpl(HttpTransportMetricsImpl httpTransportMetricsImpl, int n2, int n3, MessageConstraints messageConstraints, CharsetDecoder charsetDecoder) {
        Args.notNull(httpTransportMetricsImpl, "HTTP transport metrcis");
        Args.positive(n2, "Buffer size");
        this.metrics = httpTransportMetricsImpl;
        this.buffer = new byte[n2];
        this.bufferPos = 0;
        this.bufferLen = 0;
        this.minChunkLimit = n3 >= 0 ? n3 : 512;
        this.constraints = messageConstraints != null ? messageConstraints : MessageConstraints.DEFAULT;
        this.lineBuffer = new ByteArrayBuffer(n2);
        this.decoder = charsetDecoder;
    }

    public SessionInputBufferImpl(HttpTransportMetricsImpl httpTransportMetricsImpl, int n2) {
        this(httpTransportMetricsImpl, n2, n2, null, null);
    }

    public void bind(InputStream inputStream) {
        this.inStream = inputStream;
    }

    public boolean isBound() {
        return this.inStream != null;
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    @Override
    public int length() {
        return this.bufferLen - this.bufferPos;
    }

    @Override
    public int available() {
        return this.capacity() - this.length();
    }

    private int streamRead(byte[] byArray, int n2, int n3) throws IOException {
        Asserts.notNull(this.inStream, "Input stream");
        return this.inStream.read(byArray, n2, n3);
    }

    public int fillBuffer() throws IOException {
        int n2;
        int n3;
        int n4;
        if (this.bufferPos > 0) {
            n4 = this.bufferLen - this.bufferPos;
            if (n4 > 0) {
                System.arraycopy(this.buffer, this.bufferPos, this.buffer, 0, n4);
            }
            this.bufferPos = 0;
            this.bufferLen = n4;
        }
        if ((n4 = this.streamRead(this.buffer, n3 = this.bufferLen, n2 = this.buffer.length - n3)) == -1) {
            return -1;
        }
        this.bufferLen = n3 + n4;
        this.metrics.incrementBytesTransferred(n4);
        return n4;
    }

    public boolean hasBufferedData() {
        return this.bufferPos < this.bufferLen;
    }

    public void clear() {
        this.bufferPos = 0;
        this.bufferLen = 0;
    }

    @Override
    public int read() throws IOException {
        while (!this.hasBufferedData()) {
            int n2 = this.fillBuffer();
            if (n2 != -1) continue;
            return -1;
        }
        return this.buffer[this.bufferPos++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (byArray == null) {
            return 0;
        }
        if (this.hasBufferedData()) {
            int n5 = Math.min(n3, this.bufferLen - this.bufferPos);
            System.arraycopy(this.buffer, this.bufferPos, byArray, n2, n5);
            this.bufferPos += n5;
            return n5;
        }
        if (n3 > this.minChunkLimit) {
            int n6 = this.streamRead(byArray, n2, n3);
            if (n6 > 0) {
                this.metrics.incrementBytesTransferred(n6);
            }
            return n6;
        }
        while (!this.hasBufferedData()) {
            n4 = this.fillBuffer();
            if (n4 != -1) continue;
            return -1;
        }
        n4 = Math.min(n3, this.bufferLen - this.bufferPos);
        System.arraycopy(this.buffer, this.bufferPos, byArray, n2, n4);
        this.bufferPos += n4;
        return n4;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        if (byArray == null) {
            return 0;
        }
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int readLine(CharArrayBuffer charArrayBuffer) throws IOException {
        Args.notNull(charArrayBuffer, "Char array buffer");
        int n2 = this.constraints.getMaxLineLength();
        int n3 = 0;
        boolean bl2 = true;
        while (bl2) {
            int n4;
            int n5 = -1;
            for (n4 = this.bufferPos; n4 < this.bufferLen; ++n4) {
                if (this.buffer[n4] != 10) continue;
                n5 = n4;
                break;
            }
            if (n2 > 0 && (n4 = this.lineBuffer.length() + (n5 >= 0 ? n5 : this.bufferLen) - this.bufferPos) >= n2) {
                throw new MessageConstraintException("Maximum line length limit exceeded");
            }
            if (n5 != -1) {
                if (this.lineBuffer.isEmpty()) {
                    return this.lineFromReadBuffer(charArrayBuffer, n5);
                }
                bl2 = false;
                n4 = n5 + 1 - this.bufferPos;
                this.lineBuffer.append(this.buffer, this.bufferPos, n4);
                this.bufferPos = n5 + 1;
                continue;
            }
            if (this.hasBufferedData()) {
                n4 = this.bufferLen - this.bufferPos;
                this.lineBuffer.append(this.buffer, this.bufferPos, n4);
                this.bufferPos = this.bufferLen;
            }
            if ((n3 = this.fillBuffer()) != -1) continue;
            bl2 = false;
        }
        if (n3 == -1 && this.lineBuffer.isEmpty()) {
            return -1;
        }
        return this.lineFromLineBuffer(charArrayBuffer);
    }

    private int lineFromLineBuffer(CharArrayBuffer charArrayBuffer) throws IOException {
        int n2 = this.lineBuffer.length();
        if (n2 > 0) {
            if (this.lineBuffer.byteAt(n2 - 1) == 10) {
                --n2;
            }
            if (n2 > 0 && this.lineBuffer.byteAt(n2 - 1) == 13) {
                --n2;
            }
        }
        if (this.decoder == null) {
            charArrayBuffer.append(this.lineBuffer, 0, n2);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.lineBuffer.buffer(), 0, n2);
            n2 = this.appendDecoded(charArrayBuffer, byteBuffer);
        }
        this.lineBuffer.clear();
        return n2;
    }

    private int lineFromReadBuffer(CharArrayBuffer charArrayBuffer, int n2) throws IOException {
        int n3 = n2;
        int n4 = this.bufferPos;
        this.bufferPos = n3 + 1;
        if (n3 > n4 && this.buffer[n3 - 1] == 13) {
            --n3;
        }
        int n5 = n3 - n4;
        if (this.decoder == null) {
            charArrayBuffer.append(this.buffer, n4, n5);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer, n4, n5);
            n5 = this.appendDecoded(charArrayBuffer, byteBuffer);
        }
        return n5;
    }

    private int appendDecoded(CharArrayBuffer charArrayBuffer, ByteBuffer byteBuffer) throws IOException {
        CoderResult coderResult;
        if (!byteBuffer.hasRemaining()) {
            return 0;
        }
        if (this.cbuf == null) {
            this.cbuf = CharBuffer.allocate(1024);
        }
        this.decoder.reset();
        int n2 = 0;
        while (byteBuffer.hasRemaining()) {
            coderResult = this.decoder.decode(byteBuffer, this.cbuf, true);
            n2 += this.handleDecodingResult(coderResult, charArrayBuffer, byteBuffer);
        }
        coderResult = this.decoder.flush(this.cbuf);
        this.cbuf.clear();
        return n2 += this.handleDecodingResult(coderResult, charArrayBuffer, byteBuffer);
    }

    private int handleDecodingResult(CoderResult coderResult, CharArrayBuffer charArrayBuffer, ByteBuffer byteBuffer) throws IOException {
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        this.cbuf.flip();
        int n2 = this.cbuf.remaining();
        while (this.cbuf.hasRemaining()) {
            charArrayBuffer.append(this.cbuf.get());
        }
        this.cbuf.compact();
        return n2;
    }

    @Override
    public String readLine() throws IOException {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(64);
        int n2 = this.readLine(charArrayBuffer);
        return n2 != -1 ? charArrayBuffer.toString() : null;
    }

    @Override
    public boolean isDataAvailable(int n2) throws IOException {
        return this.hasBufferedData();
    }

    @Override
    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

