/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol;

import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequestInterceptor;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.config.RequestConfig;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol.HttpClientContext;
import java.io.IOException;
import java.util.List;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestAcceptEncoding
implements HttpRequestInterceptor {
    private final String acceptEncoding;

    public RequestAcceptEncoding(List<String> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(list.get(i2));
            }
            this.acceptEncoding = stringBuilder.toString();
        } else {
            this.acceptEncoding = "gzip,deflate";
        }
    }

    public RequestAcceptEncoding() {
        this(null);
    }

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        RequestConfig requestConfig = httpClientContext.getRequestConfig();
        if (!httpRequest.containsHeader("Accept-Encoding") && requestConfig.isContentCompressionEnabled()) {
            httpRequest.addHeader("Accept-Encoding", this.acceptEncoding);
        }
    }
}

